/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.parser;

import java.util.ArrayList;
import org.eclipse.buckminster.core.cspec.QualifiedDependency;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.cspec.parser.ComponentRequestHandler;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.UnresolvedNode;
import org.eclipse.buckminster.core.metadata.parser.AttributeRefHandler;
import org.eclipse.buckminster.core.metadata.parser.BomNodeHandler;
import org.eclipse.buckminster.core.parser.ExtensionAwareHandler;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.ChildPoppedListener;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class UnresolvedNodeHandler
extends BomNodeHandler
implements ChildPoppedListener {
    public static final String TAG = "unresolvedNode";
    private ComponentRequest m_componentRequest;
    private final ComponentRequestHandler m_requestHandler = new ComponentRequestHandler((AbstractHandler)this, new ComponentRequestBuilder());
    private ArrayList<String> m_attributes;
    private AttributeRefHandler m_attributeRefHandler;

    UnresolvedNodeHandler(AbstractHandler parent) {
        super(parent);
    }

    public void childPopped(ChildHandler child) throws SAXParseException {
        if (child == this.m_requestHandler) {
            this.m_componentRequest = this.m_requestHandler.getBuilder().createComponentRequest();
        } else if (child == this.m_attributeRefHandler) {
            if (this.m_attributes == null) {
                this.m_attributes = new ArrayList();
            }
            this.m_attributes.add(this.m_attributeRefHandler.getName());
        }
    }

    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        ExtensionAwareHandler ch;
        if ("component".equals(localName)) {
            ch = this.m_requestHandler;
        } else if ("attribute".equals(localName)) {
            if (this.m_attributeRefHandler == null) {
                this.m_attributeRefHandler = new AttributeRefHandler((AbstractHandler)this);
            }
            ch = this.m_attributeRefHandler;
        } else {
            ch = super.createHandler(uri, localName, attrs);
        }
        return ch;
    }

    BOMNode getDepNode() {
        return new UnresolvedNode(new QualifiedDependency(this.m_componentRequest, this.m_attributes));
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        if (this.m_attributes != null) {
            this.m_attributes.clear();
        }
        this.m_componentRequest = null;
    }
}

