/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.buckminster.core.common.parser.PropertyManagerHandler;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.metadata.model.WorkspaceBinding;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.VersionFactory;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceBindingHandler
extends PropertyManagerHandler {
    public static final String TAG = "workspaceBinding";
    private ComponentIdentifier m_cid;
    private UUID m_resolutionId;
    private IPath m_location;
    private IPath m_wsRoot;
    private IPath m_wsRelativePath;
    private Map<String, String> m_properties;
    private long m_timestamp;

    public WorkspaceBindingHandler(AbstractHandler parent) {
        super(parent, TAG);
    }

    @Override
    public Map<String, String> getProperties() {
        if (this.m_properties == null) {
            this.m_properties = new HashMap<String, String>();
        }
        return this.m_properties;
    }

    WorkspaceBinding getWorkspaceBinding() throws SAXException {
        return new WorkspaceBinding(this.m_location, this.m_cid, this.m_resolutionId, this.m_wsRoot, this.m_wsRelativePath, this.m_properties, this.m_timestamp);
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        super.handleAttributes(attrs);
        String name = this.getStringValue(attrs, "name");
        String ctype = WorkspaceBindingHandler.getOptionalStringValue((Attributes)attrs, (String)"componentType");
        IVersion version = null;
        String tmp = WorkspaceBindingHandler.getOptionalStringValue((Attributes)attrs, (String)"version");
        if (tmp != null) {
            String type = WorkspaceBindingHandler.getOptionalStringValue((Attributes)attrs, (String)"versionType");
            if (type == null) {
                type = "OSGi";
            }
            try {
                version = VersionFactory.createVersion(type, tmp);
            }
            catch (CoreException e) {
                throw new SAXParseException(e.getMessage(), this.getDocumentLocator());
            }
        }
        this.m_properties = null;
        this.m_cid = new ComponentIdentifier(name, ctype, version);
        this.m_location = Path.fromPortableString((String)this.getStringValue(attrs, "location"));
        this.m_wsRoot = Path.fromPortableString((String)this.getStringValue(attrs, "workspaceLocation"));
        this.m_wsRelativePath = Path.fromPortableString((String)this.getStringValue(attrs, "workspaceRelativePath"));
        this.m_timestamp = this.getLongValue(attrs, "timestamp");
        this.m_resolutionId = UUID.fromString(this.getStringValue(attrs, "resolutionId"));
    }
}

