/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.mspec.builder;

import java.util.regex.Pattern;
import org.eclipse.buckminster.core.mspec.IMaterializationNode;
import org.eclipse.buckminster.core.mspec.builder.MaterializationDirectiveBuilder;
import org.eclipse.buckminster.core.mspec.model.MaterializationNode;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

public class MaterializationNodeBuilder
extends MaterializationDirectiveBuilder
implements IMaterializationNode {
    private Pattern m_namePattern;
    private IPath m_leafArtifact;
    private String m_componentTypeID;
    private boolean m_exclude;
    private Pattern m_bindingNamePattern;
    private String m_bindingNameReplacement;
    private String m_suffix;
    private boolean m_unpack;
    private boolean m_expand = true;
    private IPath m_resourcePath;

    public void clear() {
        super.clear();
        this.m_namePattern = null;
        this.m_leafArtifact = null;
        this.m_componentTypeID = null;
        this.m_resourcePath = null;
        this.m_exclude = false;
        this.m_bindingNamePattern = null;
        this.m_bindingNameReplacement = null;
        this.m_suffix = null;
        this.m_unpack = false;
        this.m_expand = true;
    }

    public MaterializationNode createMaterializationNode() {
        return new MaterializationNode(this);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        if (adapter.isAssignableFrom(MaterializationNode.class)) {
            return new MaterializationNode(this);
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public Pattern getBindingNamePattern() {
        return this.m_bindingNamePattern;
    }

    public String getBindingNameReplacement() {
        return this.m_bindingNameReplacement;
    }

    public String getComponentTypeID() {
        return this.m_componentTypeID;
    }

    public IPath getLeafArtifact() {
        return this.m_leafArtifact;
    }

    public Pattern getNamePattern() {
        return this.m_namePattern;
    }

    public IPath getResourcePath() {
        return this.m_resourcePath;
    }

    public String getSuffix() {
        return this.m_suffix;
    }

    public void initFrom(IMaterializationNode mn) {
        super.initFrom(mn);
        this.m_namePattern = mn.getNamePattern();
        this.m_leafArtifact = mn.getLeafArtifact();
        this.m_componentTypeID = mn.getComponentTypeID();
        this.m_resourcePath = mn.getResourcePath();
        this.m_exclude = mn.isExclude();
        this.m_bindingNamePattern = mn.getBindingNamePattern();
        this.m_bindingNameReplacement = mn.getBindingNameReplacement();
        this.m_suffix = mn.getSuffix();
        this.m_unpack = mn.isUnpack();
        this.m_expand = mn.isExpand();
    }

    public boolean isExclude() {
        return this.m_exclude;
    }

    public boolean isExpand() {
        return this.m_expand;
    }

    public boolean isUnpack() {
        return this.m_unpack;
    }

    public void setBindingNamePattern(Pattern bindingNamePattern) {
        this.m_bindingNamePattern = bindingNamePattern;
    }

    public void setBindingNameReplacement(String bindingNameReplacement) {
        this.m_bindingNameReplacement = bindingNameReplacement;
    }

    public void setComponentTypeID(String componentTypeID) {
        this.m_componentTypeID = componentTypeID;
    }

    public void setExclude(boolean exclude) {
        this.m_exclude = exclude;
    }

    public void setExpand(boolean expand) {
        this.m_expand = expand;
    }

    public void setLeafArtifact(IPath leafArtifact) {
        this.m_leafArtifact = leafArtifact;
    }

    public void setNamePattern(Pattern namePattern) {
        this.m_namePattern = namePattern;
    }

    public void setResourcePath(IPath resourcePath) {
        this.m_resourcePath = resourcePath;
    }

    public void setSuffix(String suffix) {
        this.m_suffix = suffix;
    }

    public void setUnpack(boolean unpack) {
        this.m_unpack = unpack;
    }
}

