/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.parser;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.parser.CSpecParser;
import org.eclipse.buckminster.core.cspecext.model.CSpecExtension;
import org.eclipse.buckminster.core.cspecext.parser.AlterCSpecParser;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.BillOfMaterials;
import org.eclipse.buckminster.core.metadata.model.Materialization;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.metadata.model.WorkspaceBinding;
import org.eclipse.buckminster.core.metadata.parser.BillOfMaterialsParser;
import org.eclipse.buckminster.core.metadata.parser.DepNodeParser;
import org.eclipse.buckminster.core.metadata.parser.MaterializationParser;
import org.eclipse.buckminster.core.metadata.parser.ResolutionParser;
import org.eclipse.buckminster.core.metadata.parser.WorkspaceBindingParser;
import org.eclipse.buckminster.core.mspec.model.MaterializationSpec;
import org.eclipse.buckminster.core.mspec.parser.MaterializationSpecParser;
import org.eclipse.buckminster.core.parser.AbstractParser;
import org.eclipse.buckminster.core.parser.IParser;
import org.eclipse.buckminster.core.parser.IParserFactory;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.query.parser.ComponentQueryParser;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.rmap.model.ResourceMap;
import org.eclipse.buckminster.core.rmap.parser.ProviderParser;
import org.eclipse.buckminster.core.rmap.parser.ResourceMapParser;
import org.eclipse.buckminster.opml.model.OPML;
import org.eclipse.buckminster.opml.parser.OPMLParser;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserFactory
implements IParserFactory {
    public static final String PARSER_EXTENSIONS_POINT = "org.eclipse.buckminster.core.parserExtensions";
    private static final ParserFactory s_instance = new ParserFactory();
    private Map<String, List<ParserExtension>> m_parserExtensions;

    public static IParserFactory getDefault() {
        return s_instance;
    }

    @Override
    public IParser<CSpecExtension> getAlterCSpecParser(boolean validating) throws CoreException {
        return new AlterCSpecParser(this.getParserExtensions("cspec", "cspecExtension"), validating);
    }

    @Override
    public IParser<BillOfMaterials> getBillOfMaterialsParser(boolean validating) throws CoreException {
        return new BillOfMaterialsParser(this.getParserExtensions("billOfMaterials", "componentQuery", "provider", "cspec", "resolution", "depnode"), validating);
    }

    @Override
    public IParser<ComponentQuery> getComponentQueryParser(boolean validating) throws CoreException {
        return new ComponentQueryParser(this.getParserExtensions("componentQuery"), validating);
    }

    @Override
    public IParser<CSpec> getCSpecParser(boolean validating) throws CoreException {
        return new CSpecParser(this.getParserExtensions("cspec"), validating);
    }

    @Override
    public IParser<BOMNode> getDepNodeParser() throws CoreException {
        return new DepNodeParser(this.getParserExtensions("resolution", "depnode"));
    }

    @Override
    public IParser<Materialization> getMaterializationParser() throws CoreException {
        return new MaterializationParser(this.getParserExtensions("materialization"));
    }

    @Override
    public IParser<MaterializationSpec> getMaterializationSpecParser(boolean validating) throws CoreException {
        return new MaterializationSpecParser(this.getParserExtensions("mspec"), validating);
    }

    @Override
    public IParser<OPML> getOPMLParser(boolean validating) throws CoreException {
        try {
            return new OPMLParserExt(validating);
        }
        catch (SAXException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    private synchronized List<ParserExtension> getParserExtensions(String ... parserIds) {
        if (this.m_parserExtensions == null) {
            try {
                this.m_parserExtensions = this.loadParserExtensions();
            }
            catch (CoreException e) {
                CorePlugin.getLogger().warning((Throwable)e, Messages.Unable_to_load_parser_extensions, new Object[0]);
                this.m_parserExtensions = Collections.emptyMap();
            }
        }
        List<ParserExtension> result = null;
        boolean mutable = false;
        String[] stringArray = parserIds;
        int n = parserIds.length;
        int n2 = 0;
        while (n2 < n) {
            String parserId = stringArray[n2];
            List<ParserExtension> pel = this.m_parserExtensions.get(parserId);
            if (pel != null) {
                if (result == null) {
                    result = pel;
                } else {
                    if (!mutable) {
                        ArrayList<ParserExtension> mutableList = new ArrayList<ParserExtension>();
                        mutableList.addAll(result);
                        result = mutableList;
                        mutable = true;
                    }
                    result.addAll(pel);
                }
            }
            ++n2;
        }
        return result == null || result.size() == 0 ? Collections.emptyList() : result;
    }

    @Override
    public IParser<Provider> getProviderParser(boolean validating) throws CoreException {
        return new ProviderParser(this.getParserExtensions("provider"), validating);
    }

    @Override
    public IParser<Resolution> getResolutionParser() throws CoreException {
        return new ResolutionParser(this.getParserExtensions("resolution"));
    }

    @Override
    public IParser<ResourceMap> getResourceMapParser(boolean validating) throws CoreException {
        return new ResourceMapParser(this.getParserExtensions("rmap", "provider"), validating);
    }

    @Override
    public IParser<WorkspaceBinding> getWorkspaceBindingParser(boolean validating) throws CoreException {
        return new WorkspaceBindingParser(this.getParserExtensions("provider", "cspec", "resolution"), validating);
    }

    private Map<String, List<ParserExtension>> loadParserExtensions() throws CoreException {
        IExtensionRegistry exReg = Platform.getExtensionRegistry();
        HashMap<String, List<ParserExtension>> peMap = new HashMap<String, List<ParserExtension>>();
        IConfigurationElement[] iConfigurationElementArray = exReg.getConfigurationElementsFor(PARSER_EXTENSIONS_POINT);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement namespace = iConfigurationElementArray[n2];
            Bundle bundle = Platform.getBundle((String)namespace.getNamespaceIdentifier());
            URL resource = bundle.getResource(namespace.getAttribute("resource"));
            ParserExtension pe = new ParserExtension(namespace.getAttribute("namespace"), resource);
            Object[] objectArray = namespace.getChildren("handler");
            int n3 = objectArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement handler = objectArray[n4];
                try {
                    pe.addHandler(handler.getAttribute("type"), bundle.loadClass(handler.getAttribute("class")).asSubclass(ChildHandler.class));
                }
                catch (ClassNotFoundException e) {
                    throw BuckminsterException.wrap((Throwable)e);
                }
                ++n4;
            }
            objectArray = namespace.getAttribute("parserIds").split(",");
            n3 = objectArray.length;
            n4 = 0;
            while (n4 < n3) {
                IConfigurationElement parserId = objectArray[n4];
                List<ParserExtension> peList = peMap.get(parserId);
                if (peList == null) {
                    peList = new ArrayList<ParserExtension>();
                    peMap.put((String)parserId, peList);
                }
                peList.add(pe);
                ++n4;
            }
            ++n2;
        }
        return peMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OPMLParserExt
    extends OPMLParser
    implements IParser<OPML> {
        OPMLParserExt(boolean validating) throws SAXException {
            super(validating);
        }

        @Override
        public OPML parse(String systemId, InputStream input) throws CoreException {
            IFile[] files = AbstractParser.clearMarkers(systemId);
            try {
                OPML oPML = this.parseInput(systemId, input);
                return oPML;
            }
            catch (SAXParseException e) {
                AbstractParser.setMarkers(files, e);
                throw BuckminsterException.wrap((Throwable)e);
            }
            catch (Exception e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
            finally {
                this.getXMLReader().setContentHandler((ContentHandler)((Object)this));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParserExtension {
        private final String m_namespace;
        private final URL m_resource;
        private final Map<String, Class<? extends ChildHandler>> m_handlers = new HashMap<String, Class<? extends ChildHandler>>();

        public ParserExtension(String namespace, URL resource) {
            this.m_namespace = namespace;
            this.m_resource = resource;
        }

        void addHandler(String xsiType, Class<? extends ChildHandler> clazz) {
            this.m_handlers.put(xsiType, clazz);
        }

        public final ChildHandler getHandler(AbstractHandler parent, String xsiType) throws CoreException {
            Class<? extends ChildHandler> handlerClass = this.m_handlers.get(xsiType);
            try {
                Constructor<? extends ChildHandler> ctor = handlerClass.getConstructor(AbstractHandler.class);
                return ctor.newInstance(parent);
            }
            catch (Exception e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }

        public final String getNamespace() {
            return this.m_namespace;
        }

        public final URL getResource() {
            return this.m_resource;
        }
    }
}

