/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.query.builder;

import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.query.IAdvisorNode;
import org.eclipse.buckminster.core.query.model.AdvisorNode;
import org.eclipse.buckminster.core.query.model.MutableLevel;
import org.eclipse.buckminster.core.query.model.SourceLevel;
import org.eclipse.buckminster.core.version.IVersionDesignator;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvisorNodeBuilder
implements IAdvisorNode {
    private boolean m_allowCircularDependency;
    private final ArrayList<String> m_attributes = new ArrayList();
    private VersionSelector[] m_branchTagPath;
    private String m_componentType;
    private Documentation m_documentation;
    private MutableLevel m_mutableLevel;
    private Pattern m_namePattern;
    private URL m_overlayFolder;
    private Map<String, String> m_properties;
    private boolean m_prune;
    private int[] m_resolutionPrio;
    private long m_revision;
    private boolean m_skipComponent;
    private SourceLevel m_sourceLevel;
    private boolean m_systemDiscovery;
    private Date m_timestamp;
    private boolean m_useTargetPlatform;
    private boolean m_useMaterialization;
    private boolean m_useWorkspace;
    private boolean m_useRemoteResolution;
    private IVersionDesignator m_versionOverride;

    public AdvisorNodeBuilder() {
        this.clear();
    }

    public void addAttribute(String attribute) {
        this.m_attributes.add(attribute);
    }

    public void addAttributes(List<String> attributes) {
        this.m_attributes.addAll(attributes);
    }

    @Override
    public boolean allowCircularDependency() {
        return this.m_allowCircularDependency;
    }

    public void clear() {
        this.m_attributes.clear();
        this.m_properties = null;
        this.m_documentation = null;
        this.m_componentType = null;
        this.m_mutableLevel = MutableLevel.INDIFFERENT;
        this.m_namePattern = null;
        this.m_overlayFolder = null;
        this.m_prune = false;
        this.m_skipComponent = false;
        this.m_allowCircularDependency = false;
        this.m_sourceLevel = SourceLevel.INDIFFERENT;
        this.m_useTargetPlatform = true;
        this.m_useMaterialization = true;
        this.m_useWorkspace = true;
        this.m_versionOverride = null;
        this.m_useRemoteResolution = true;
        this.m_systemDiscovery = true;
        this.m_branchTagPath = VersionSelector.EMPTY_PATH;
        this.m_revision = -1L;
        this.m_timestamp = null;
        this.m_resolutionPrio = IAdvisorNode.DEFAULT_RESOLUTION_PRIO;
    }

    public AdvisorNode create() {
        return new AdvisorNode(this);
    }

    @Override
    public List<String> getAttributes() {
        return this.m_attributes;
    }

    @Override
    public VersionSelector[] getBranchTagPath() {
        return this.m_branchTagPath;
    }

    @Override
    public String getComponentTypeID() {
        return this.m_componentType;
    }

    @Override
    public Documentation getDocumentation() {
        return this.m_documentation;
    }

    public IPath getMaterializationLocation(String projectName) {
        return null;
    }

    @Override
    public MutableLevel getMutableLevel() {
        return this.m_mutableLevel;
    }

    @Override
    public Pattern getNamePattern() {
        return this.m_namePattern;
    }

    @Override
    public URL getOverlayFolder() {
        return this.m_overlayFolder;
    }

    @Override
    public Map<String, String> getProperties() {
        if (this.m_properties == null) {
            this.m_properties = new HashMap<String, String>();
        }
        return this.m_properties;
    }

    @Override
    public int[] getResolutionPrio() {
        return this.m_resolutionPrio;
    }

    @Override
    public long getRevision() {
        return this.m_revision;
    }

    @Override
    public SourceLevel getSourceLevel() {
        return this.m_sourceLevel;
    }

    @Override
    public Date getTimestamp() {
        return this.m_timestamp;
    }

    @Override
    public IVersionDesignator getVersionOverride() {
        return this.m_versionOverride;
    }

    public void initFrom(IAdvisorNode node) {
        this.clear();
        this.m_allowCircularDependency = node.allowCircularDependency();
        this.m_attributes.addAll(node.getAttributes());
        this.m_componentType = node.getComponentTypeID();
        this.m_documentation = node.getDocumentation();
        this.m_mutableLevel = node.getMutableLevel();
        this.m_namePattern = node.getNamePattern();
        this.m_overlayFolder = node.getOverlayFolder();
        Map<String, String> props = node.getProperties();
        if (props.size() > 0) {
            this.m_properties = new HashMap<String, String>(props);
        }
        this.m_prune = node.isPrune();
        this.m_skipComponent = node.skipComponent();
        this.m_sourceLevel = node.getSourceLevel();
        this.m_useMaterialization = node.isUseMaterialization();
        this.m_useRemoteResolution = node.isUseRemoteResolution();
        this.m_useTargetPlatform = node.isUseTargetPlatform();
        this.m_useWorkspace = node.isUseWorkspace();
        this.m_versionOverride = node.getVersionOverride();
        this.m_systemDiscovery = node.isSystemDiscovery();
        this.m_branchTagPath = node.getBranchTagPath();
        this.m_revision = node.getRevision();
        this.m_timestamp = node.getTimestamp();
        this.m_resolutionPrio = node.getResolutionPrio();
    }

    @Override
    public boolean isPrune() {
        return this.m_prune;
    }

    @Override
    public boolean isSystemDiscovery() {
        return this.m_systemDiscovery;
    }

    @Override
    public boolean isUseMaterialization() {
        return this.m_useMaterialization;
    }

    @Override
    public boolean isUseRemoteResolution() {
        return this.m_useRemoteResolution;
    }

    @Override
    public boolean isUseTargetPlatform() {
        return this.m_useTargetPlatform;
    }

    @Override
    public boolean isUseWorkspace() {
        return this.m_useWorkspace;
    }

    public void setAllowCircularDependency(boolean allowCircularDependency) {
        this.m_allowCircularDependency = allowCircularDependency;
    }

    public void setBranchTagPath(VersionSelector[] branchTagPath) {
        this.m_branchTagPath = branchTagPath == null ? VersionSelector.EMPTY_PATH : branchTagPath;
    }

    public void setComponentTypeID(String componentType) {
        this.m_componentType = componentType;
    }

    public void setDocumentation(Documentation documentation) {
        this.m_documentation = documentation;
    }

    public void setMutableLevel(MutableLevel mutableLevel) {
        this.m_mutableLevel = mutableLevel == null ? MutableLevel.INDIFFERENT : mutableLevel;
    }

    public void setNamePattern(Pattern namePattern) {
        this.m_namePattern = namePattern;
    }

    public void setOverlayFolder(URL addOnFolder) {
        this.m_overlayFolder = addOnFolder;
    }

    public void setPrune(boolean prune) {
        this.m_prune = prune;
    }

    public void setResolutionPrio(int[] resolutionPrio) {
        this.m_resolutionPrio = resolutionPrio;
    }

    public void setRevision(long revision) {
        this.m_revision = revision;
    }

    public void setSkipComponent(boolean skipComponent) {
        this.m_skipComponent = skipComponent;
    }

    public void setSourceLevel(SourceLevel sourceLevel) {
        this.m_sourceLevel = sourceLevel == null ? SourceLevel.INDIFFERENT : sourceLevel;
    }

    public void setSystemDiscovery(boolean systemDiscovery) {
        this.m_systemDiscovery = systemDiscovery;
    }

    public void setTimestamp(Date timestamp) {
        this.m_timestamp = timestamp;
    }

    public void setUseMaterialization(boolean useMaterialization) {
        this.m_useMaterialization = useMaterialization;
    }

    public void setUseRemoteResolution(boolean useRemoteResolution) {
        this.m_useRemoteResolution = useRemoteResolution;
    }

    public void setUseTargetPlatform(boolean useInstalled) {
        this.m_useTargetPlatform = useInstalled;
    }

    public void setUseWorkspace(boolean useProject) {
        this.m_useWorkspace = useProject;
    }

    public void setVersionOverride(IVersionDesignator versionOverride) {
        this.m_versionOverride = versionOverride;
    }

    @Override
    public boolean skipComponent() {
        return this.m_skipComponent;
    }
}

