/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.query.model;

import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.common.model.SAXEmitter;
import org.eclipse.buckminster.core.helpers.DateAndTimeUtils;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.query.IAdvisorNode;
import org.eclipse.buckminster.core.query.builder.AdvisorNodeBuilder;
import org.eclipse.buckminster.core.query.model.MutableLevel;
import org.eclipse.buckminster.core.query.model.SourceLevel;
import org.eclipse.buckminster.core.version.IVersionDesignator;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.sax.AbstractSaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvisorNode
extends AbstractSaxableElement
implements Cloneable,
IAdvisorNode {
    public static final String ATTR_ATTRIBUTES = "attributes";
    public static final String ATTR_COMPONENT_TYPE = "componentType";
    public static final String ATTR_MUTABLE_LEVEL = "mutableLevel";
    public static final String ATTR_NAME_PATTERN = "namePattern";
    public static final String ATTR_OVERLAY_FOLDER = "overlayFolder";
    public static final String ATTR_PRUNE = "prune";
    public static final String ATTR_SKIP_COMPONENT = "skipComponent";
    public static final String ATTR_SOURCE_LEVEL = "sourceLevel";
    public static final String ATTR_USE_TARGET_PLATFORM = "useTargetPlatform";
    public static final String ATTR_USE_MATERIALIZATION = "useMaterialization";
    public static final String ATTR_USE_WORKSPACE = "useWorkspace";
    public static final String ATTR_VERSION_OVERRIDE = "versionOverride";
    public static final String ATTR_VERSION_OVERRIDE_TYPE = "versionOverrideType";
    public static final String ATTR_ALLOW_CIRCULAR_DEPENDENCY = "allowCircularDependency";
    public static final String ATTR_WHEN_NOT_EMPTY = "whenNotEmpty";
    public static final String ATTR_USE_REMOTE_RESOLUTION = "useRemoteResolution";
    public static final String ATTR_SYSTEM_DISCOVERY = "systemDiscovery";
    public static final String ATTR_BRANCH_TAG_PATH = "branchTagPath";
    public static final String ATTR_REVISION = "revision";
    public static final String ATTR_TIMESTAMP = "timestamp";
    public static final String ATTR_RESOLUTION_PRIO = "resolutionPrio";
    public static final String TAG = "advisorNode";
    private final boolean m_allowCircularDependency;
    private final Documentation m_documentation;
    private final List<String> m_attributes;
    private final String m_componentTypeID;
    private final MutableLevel m_mutableLevel;
    private final Pattern m_namePattern;
    private final URL m_overlayFolder;
    private final Map<String, String> m_properties;
    private final boolean m_prune;
    private final boolean m_skipComponent;
    private final SourceLevel m_sourceLevel;
    private final boolean m_useTargetPlatform;
    private final boolean m_useMaterialization;
    private final boolean m_useWorkspace;
    private final IVersionDesignator m_versionOverride;
    private final boolean m_useRemoteResolution;
    private final boolean m_systemDiscovery;
    private final VersionSelector[] m_branchTagPath;
    private final long m_revision;
    private final Date m_timestamp;
    private final int[] m_resolutionPrio;

    public AdvisorNode(AdvisorNodeBuilder bld) {
        this.m_documentation = bld.getDocumentation();
        this.m_allowCircularDependency = bld.allowCircularDependency();
        this.m_namePattern = bld.getNamePattern();
        this.m_componentTypeID = bld.getComponentTypeID();
        this.m_overlayFolder = bld.getOverlayFolder();
        this.m_prune = bld.isPrune();
        this.m_mutableLevel = bld.getMutableLevel();
        this.m_sourceLevel = bld.getSourceLevel();
        this.m_skipComponent = bld.skipComponent();
        this.m_useMaterialization = bld.isUseMaterialization();
        this.m_useTargetPlatform = bld.isUseTargetPlatform();
        this.m_useWorkspace = bld.isUseWorkspace();
        this.m_versionOverride = bld.getVersionOverride();
        this.m_useRemoteResolution = bld.isUseRemoteResolution();
        this.m_systemDiscovery = bld.isSystemDiscovery();
        this.m_branchTagPath = bld.getBranchTagPath();
        this.m_revision = bld.getRevision();
        this.m_timestamp = bld.getTimestamp();
        this.m_resolutionPrio = bld.getResolutionPrio();
        this.m_attributes = Utils.createUnmodifiableList(bld.getAttributes());
        this.m_properties = ExpandingProperties.createUnmodifiableProperties(bld.getProperties());
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        String tmp;
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_NAME_PATTERN, (String)this.m_namePattern.toString());
        if (this.m_overlayFolder != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_OVERLAY_FOLDER, (String)this.m_overlayFolder.toString());
        }
        if (this.m_componentTypeID != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_COMPONENT_TYPE, (String)this.m_componentTypeID);
        }
        if (this.m_mutableLevel != MutableLevel.INDIFFERENT) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_MUTABLE_LEVEL, (String)this.m_mutableLevel.name());
        }
        if (this.m_sourceLevel != SourceLevel.INDIFFERENT) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_SOURCE_LEVEL, (String)this.m_sourceLevel.name());
        }
        if (this.m_skipComponent) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_SKIP_COMPONENT, (String)"true");
        }
        if (this.m_allowCircularDependency) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_ALLOW_CIRCULAR_DEPENDENCY, (String)"true");
        }
        if (!this.m_systemDiscovery) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_SYSTEM_DISCOVERY, (String)"false");
        }
        if (!this.m_useMaterialization) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_USE_MATERIALIZATION, (String)"false");
        }
        if (!this.m_useRemoteResolution) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_USE_REMOTE_RESOLUTION, (String)"false");
        }
        if (!this.m_useTargetPlatform) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_USE_TARGET_PLATFORM, (String)"false");
        }
        if (!this.m_useWorkspace) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_USE_WORKSPACE, (String)"false");
        }
        if (this.m_versionOverride != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_VERSION_OVERRIDE, (String)this.m_versionOverride.toString());
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_VERSION_OVERRIDE_TYPE, (String)this.m_versionOverride.getVersion().getType().getId());
        }
        if ((tmp = TextUtils.concat(this.m_attributes, ",")) != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_ATTRIBUTES, (String)tmp);
        }
        if (this.m_prune) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_PRUNE, (String)"true");
        }
        if ((tmp = VersionSelector.toString(this.m_branchTagPath)) != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_BRANCH_TAG_PATH, (String)tmp);
        }
        if (!Arrays.equals(this.m_resolutionPrio, DEFAULT_RESOLUTION_PRIO)) {
            StringBuilder bld = new StringBuilder();
            bld.append(this.m_resolutionPrio[0]);
            int idx = 1;
            while (idx < this.m_resolutionPrio.length) {
                bld.append(',');
                bld.append(this.m_resolutionPrio[idx]);
                ++idx;
            }
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_RESOLUTION_PRIO, (String)bld.toString());
        }
        if (this.m_revision != -1L) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_REVISION, (String)Long.toString(this.m_revision));
        }
        if (this.m_timestamp != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_TIMESTAMP, (String)DateAndTimeUtils.toISOFormat(this.m_timestamp));
        }
    }

    @Override
    public boolean allowCircularDependency() {
        return this.m_allowCircularDependency;
    }

    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        if (this.m_documentation != null) {
            this.m_documentation.toSax(handler, namespace, prefix, this.m_documentation.getDefaultTag());
        }
        SAXEmitter.emitProperties(handler, this.m_properties, namespace, prefix, true, false);
    }

    @Override
    public final List<String> getAttributes() {
        return this.m_attributes;
    }

    @Override
    public final VersionSelector[] getBranchTagPath() {
        return this.m_branchTagPath;
    }

    @Override
    public final String getComponentTypeID() {
        return this.m_componentTypeID;
    }

    public String getDefaultTag() {
        return TAG;
    }

    @Override
    public Documentation getDocumentation() {
        return this.m_documentation;
    }

    @Override
    public final MutableLevel getMutableLevel() {
        return this.m_mutableLevel;
    }

    @Override
    public final Pattern getNamePattern() {
        return this.m_namePattern;
    }

    @Override
    public URL getOverlayFolder() {
        return this.m_overlayFolder;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.m_properties;
    }

    @Override
    public int[] getResolutionPrio() {
        return this.m_resolutionPrio;
    }

    @Override
    public long getRevision() {
        return this.m_revision;
    }

    @Override
    public final SourceLevel getSourceLevel() {
        return this.m_sourceLevel;
    }

    @Override
    public Date getTimestamp() {
        return this.m_timestamp;
    }

    @Override
    public final IVersionDesignator getVersionOverride() {
        return this.m_versionOverride;
    }

    @Override
    public final boolean isPrune() {
        return this.m_prune;
    }

    @Override
    public final boolean isSystemDiscovery() {
        return this.m_systemDiscovery;
    }

    @Override
    public final boolean isUseMaterialization() {
        return this.m_useMaterialization;
    }

    @Override
    public final boolean isUseRemoteResolution() {
        return this.m_useRemoteResolution;
    }

    @Override
    public final boolean isUseTargetPlatform() {
        return this.m_useTargetPlatform;
    }

    @Override
    public final boolean isUseWorkspace() {
        return this.m_useWorkspace;
    }

    @Override
    public final boolean skipComponent() {
        return this.m_skipComponent;
    }
}

