/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.query.model;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.common.model.SAXEmitter;
import org.eclipse.buckminster.core.cspec.model.ComponentName;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.helpers.BMProperties;
import org.eclipse.buckminster.core.metadata.StorageManager;
import org.eclipse.buckminster.core.metadata.model.IUUIDPersisted;
import org.eclipse.buckminster.core.parser.IParser;
import org.eclipse.buckminster.core.parser.IParserFactory;
import org.eclipse.buckminster.core.query.IAdvisorNode;
import org.eclipse.buckminster.core.query.IComponentQuery;
import org.eclipse.buckminster.core.query.builder.AdvisorNodeBuilder;
import org.eclipse.buckminster.core.query.builder.ComponentQueryBuilder;
import org.eclipse.buckminster.core.query.model.AdvisorNode;
import org.eclipse.buckminster.core.rmap.model.ProviderScore;
import org.eclipse.buckminster.core.version.IVersionDesignator;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.download.DownloadManager;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.buckminster.sax.UUIDKeyed;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentQuery
extends UUIDKeyed
implements IUUIDPersisted,
IComponentQuery {
    public static final String ATTR_PROPERTIES = "properties";
    public static final String ATTR_RESOURCE_MAP = "resourceMap";
    public static final String ATTR_SHORT_DESC = "shortDesc";
    public static final String ELEM_ROOT_REQUEST = "rootRequest";
    public static final int SEQUENCE_NUMBER = 4;
    public static final String TAG = "componentQuery";
    private final List<AdvisorNode> m_advisorNodes;
    private transient Map<String, String> m_allProperties;
    private final Documentation m_documentation;
    private final Map<String, String> m_properties;
    private final URL m_contextURL;
    private final String m_propertiesURL;
    private final String m_resourceMapURL;
    private final ComponentRequest m_rootRequest;
    private final String m_shortDesc;
    private transient IConnectContext m_connectContext;

    public static ComponentQuery fromStream(URL url, IConnectContext cctx, InputStream stream, boolean validating) throws CoreException {
        try {
            IParserFactory pf = CorePlugin.getDefault().getParserFactory();
            IParser<ComponentQuery> parser = pf.getComponentQueryParser(false);
            ComponentQuery cquery = parser.parse(url.toString(), stream);
            cquery.setConnectContext(cctx);
            return cquery;
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    public static ComponentQuery fromURL(URL url, IConnectContext cctx, boolean validating) throws CoreException {
        InputStream stream = null;
        try {
            stream = DownloadManager.read((URL)url, (IConnectContext)cctx);
            ComponentQuery componentQuery = ComponentQuery.fromStream(url, cctx, stream, validating);
            return componentQuery;
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        finally {
            IOUtils.close((Closeable)stream);
        }
    }

    public ComponentQuery(ComponentQueryBuilder bld) {
        this.m_documentation = bld.getDocumentation();
        this.m_shortDesc = bld.getShortDesc();
        this.m_propertiesURL = bld.getPropertiesURL();
        this.m_resourceMapURL = bld.getResourceMapURL();
        this.m_rootRequest = bld.getRootRequest();
        List<AdvisorNodeBuilder> advisorNodeBuilders = bld.getAdvisoryNodes();
        if (advisorNodeBuilders.size() == 0) {
            this.m_advisorNodes = Collections.emptyList();
        } else {
            ArrayList<AdvisorNode> advisorNodes = new ArrayList<AdvisorNode>(advisorNodeBuilders.size());
            for (AdvisorNodeBuilder nodeBld : advisorNodeBuilders) {
                advisorNodes.add(nodeBld.create());
            }
            this.m_advisorNodes = Collections.unmodifiableList(advisorNodes);
        }
        Map<String, String> properties = bld.getDeclaredProperties();
        this.m_properties = properties == null || properties.size() == 0 ? Collections.emptyMap() : Collections.unmodifiableMap(new ExpandingProperties<String>(properties));
        this.m_contextURL = bld.getContextURL();
    }

    public boolean allowCircularDependency(ComponentName cName) {
        IAdvisorNode node = this.getMatchingNode(cName);
        return node == null ? false : node.allowCircularDependency();
    }

    @Override
    public List<? extends IAdvisorNode> getAdvisoryNodes() {
        return this.m_advisorNodes;
    }

    public List<String> getAttributes(ComponentName cName) {
        IAdvisorNode node = this.getMatchingNode(cName);
        return node == null ? Collections.emptyList() : node.getAttributes();
    }

    public VersionSelector[] getBranchTagPath(ComponentName cName) {
        IAdvisorNode node = this.getMatchingNode(cName);
        return node == null ? VersionSelector.EMPTY_PATH : node.getBranchTagPath();
    }

    public IConnectContext getConnectContext() {
        return this.m_connectContext;
    }

    @Override
    public URL getContextURL() {
        return this.m_contextURL;
    }

    @Override
    public Map<String, String> getDeclaredProperties() {
        return this.m_properties;
    }

    public String getDefaultTag() {
        return TAG;
    }

    @Override
    public Documentation getDocumentation() {
        return this.m_documentation;
    }

    public ComponentRequest getExpandedRootRequest(Map<String, ? extends Object> properties) {
        String expName;
        String name = this.m_rootRequest.getName();
        return name.equals(expName = ExpandingProperties.expand(properties, name, 0)) ? this.m_rootRequest : new ComponentRequest(expName, this.m_rootRequest.getComponentTypeID(), this.m_rootRequest.getVersionDesignator());
    }

    public synchronized Map<String, String> getGlobalProperties() {
        block8: {
            if (this.m_allProperties != null) {
                return this.m_allProperties;
            }
            this.m_allProperties = new ExpandingProperties<String>();
            this.m_allProperties.putAll(this.m_properties);
            if (this.m_propertiesURL != null) {
                URL propsURL = this.getResolvedPropertiesURL();
                InputStream input = null;
                try {
                    try {
                        input = DownloadManager.read((URL)propsURL, (IConnectContext)this.getConnectContext());
                        BMProperties urlProps = new BMProperties(input);
                        if (urlProps.size() > 0) {
                            this.m_allProperties = new ExpandingProperties<String>(this.m_allProperties);
                            this.m_allProperties.putAll(urlProps);
                        }
                    }
                    catch (Exception e) {
                        CorePlugin.getLogger().info(NLS.bind((String)Messages.Unable_to_read_property_file_0_1, (Object)propsURL, (Object)e.toString()), new Object[0]);
                        IOUtils.close((Closeable)input);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.close(input);
                    throw throwable;
                }
                IOUtils.close((Closeable)input);
            }
        }
        return this.m_allProperties;
    }

    public IAdvisorNode getMatchingNode(ComponentName cName) {
        String name = cName.getName();
        for (IAdvisorNode iAdvisorNode : this.m_advisorNodes) {
            String matchingType;
            Pattern pattern = iAdvisorNode.getNamePattern();
            if (!pattern.matcher(name).find() || (matchingType = iAdvisorNode.getComponentTypeID()) != null && !matchingType.equals(cName.getComponentTypeID())) continue;
            return iAdvisorNode;
        }
        return null;
    }

    @Override
    public IAdvisorNode getNodeByPattern(String pattern, String componentTypeID) {
        for (IAdvisorNode iAdvisorNode : this.m_advisorNodes) {
            if (!iAdvisorNode.getNamePattern().toString().equals(pattern) || !Trivial.equalsAllowNull((Object)iAdvisorNode.getComponentTypeID(), (Object)componentTypeID)) continue;
            return iAdvisorNode;
        }
        return null;
    }

    public URL getOverlayFolder(ComponentName cName) {
        IAdvisorNode node = this.getMatchingNode(cName);
        return node == null ? null : node.getOverlayFolder();
    }

    @Override
    public String getPropertiesURL() {
        return this.m_propertiesURL;
    }

    public ProviderScore getProviderScore(ComponentName cName, boolean mutable, boolean source) {
        IAdvisorNode node = this.getMatchingNode(cName);
        if (node == null) {
            return ProviderScore.GOOD;
        }
        ProviderScore mutableScore = ProviderScore.FAIR;
        switch (node.getMutableLevel()) {
            case REQUIRE: {
                if (!mutable) {
                    return ProviderScore.REJECTED;
                }
                mutableScore = ProviderScore.PREFERRED;
                break;
            }
            case DESIRE: {
                mutableScore = mutable ? ProviderScore.GOOD : ProviderScore.BAD;
                break;
            }
            case AVOID: {
                mutableScore = mutable ? ProviderScore.BAD : ProviderScore.GOOD;
                break;
            }
            case REJECT: {
                if (mutable) {
                    return ProviderScore.REJECTED;
                }
                mutableScore = ProviderScore.PREFERRED;
            }
        }
        ProviderScore sourceScore = ProviderScore.FAIR;
        switch (node.getSourceLevel()) {
            case REQUIRE: {
                if (!source) {
                    return ProviderScore.REJECTED;
                }
                sourceScore = ProviderScore.PREFERRED;
                break;
            }
            case DESIRE: {
                sourceScore = source ? ProviderScore.GOOD : ProviderScore.BAD;
                break;
            }
            case AVOID: {
                sourceScore = source ? ProviderScore.BAD : ProviderScore.GOOD;
                break;
            }
            case REJECT: {
                if (source) {
                    return ProviderScore.REJECTED;
                }
                sourceScore = ProviderScore.PREFERRED;
            }
        }
        return ProviderScore.values()[(sourceScore.ordinal() + mutableScore.ordinal()) / 2];
    }

    public int[] getResolutionPrio(ComponentName cName) {
        IAdvisorNode node = this.getMatchingNode(cName);
        return node == null ? IAdvisorNode.DEFAULT_RESOLUTION_PRIO : node.getResolutionPrio();
    }

    public URL getResolvedPropertiesURL() {
        return URLUtils.resolveURL((URL)this.m_contextURL, (String)ExpandingProperties.expand(BMProperties.getSystemProperties(), this.m_propertiesURL, 0));
    }

    public URL getResolvedResourceMapURL() {
        return URLUtils.resolveURL((URL)this.m_contextURL, (String)ExpandingProperties.expand(BMProperties.getSystemProperties(), this.m_resourceMapURL, 0));
    }

    @Override
    public String getResourceMapURL() {
        return this.m_resourceMapURL;
    }

    public long getRevision(ComponentName cName) {
        IAdvisorNode node = this.getMatchingNode(cName);
        return node == null ? -1L : node.getRevision();
    }

    @Override
    public ComponentRequest getRootRequest() {
        return this.m_rootRequest;
    }

    @Override
    public String getShortDesc() {
        return this.m_shortDesc;
    }

    public String getTagInfo() {
        return NLS.bind((String)Messages.Query_for_0, (Object)this.m_rootRequest);
    }

    public Date getTimestamp(ComponentName cName) {
        IAdvisorNode node = this.getMatchingNode(cName);
        return node == null ? null : node.getTimestamp();
    }

    public IVersionDesignator getVersionOverride(ComponentName cName) {
        IAdvisorNode node = this.getMatchingNode(cName);
        return node == null ? null : node.getVersionOverride();
    }

    @Override
    public boolean isPersisted(StorageManager sm) throws CoreException {
        return false;
    }

    public boolean isPrune(ComponentName cName) {
        IAdvisorNode node = this.getMatchingNode(cName);
        return node == null ? false : node.isPrune();
    }

    @Override
    public void remove(StorageManager sm) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void removeAdvisorNode(IAdvisorNode node) {
        this.m_advisorNodes.remove(node);
    }

    public ComponentQuery resolve() {
        ComponentQueryBuilder bld = new ComponentQueryBuilder();
        bld.initFrom(this);
        URL tmp = this.getResolvedPropertiesURL();
        if (tmp != null) {
            bld.setPropertiesURL(tmp.toString());
        }
        if ((tmp = this.getResolvedResourceMapURL()) != null) {
            bld.setResourceMapURL(tmp.toString());
        }
        bld.setContextURL(null);
        return bld.createComponentQuery();
    }

    public boolean skipComponent(ComponentName cName) {
        IAdvisorNode node = this.getMatchingNode(cName);
        return node == null ? false : node.skipComponent();
    }

    @Override
    public void store(StorageManager sm) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void toSax(ContentHandler handler) throws SAXException {
        handler.startDocument();
        this.toSax(handler, "http://www.eclipse.org/buckminster/CQuery-1.0", "cq", this.getDefaultTag());
        handler.endDocument();
    }

    public void toSax(ContentHandler handler, String namespace, String prefix, String localName) throws SAXException {
        handler.startPrefixMapping("cq", "http://www.eclipse.org/buckminster/CQuery-1.0");
        super.toSax(handler, namespace, prefix, localName);
        handler.endPrefixMapping("cq");
    }

    public boolean useMaterialization(ComponentName cName) {
        IAdvisorNode node = this.getMatchingNode(cName);
        return node == null ? true : node.isUseMaterialization();
    }

    public boolean useResolutionService(ComponentName cName) {
        IAdvisorNode node = this.getMatchingNode(cName);
        return node == null ? true : node.isUseRemoteResolution();
    }

    public boolean useTargetPlatform(ComponentName cName) {
        IAdvisorNode node = this.getMatchingNode(cName);
        return node == null ? true : node.isUseTargetPlatform();
    }

    public boolean useWorkspace(ComponentName cName) {
        IAdvisorNode node = this.getMatchingNode(cName);
        return node == null ? true : node.isUseWorkspace();
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        if (this.m_resourceMapURL != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_RESOURCE_MAP, (String)this.m_resourceMapURL.toString());
        }
        if (this.m_propertiesURL != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_PROPERTIES, (String)this.m_propertiesURL.toString());
        }
        if (this.m_shortDesc != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_SHORT_DESC, (String)this.m_shortDesc);
        }
    }

    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        if (this.m_documentation != null) {
            this.m_documentation.toSax(handler, namespace, prefix, this.m_documentation.getDefaultTag());
        }
        this.m_rootRequest.toSax(handler, namespace, prefix, ELEM_ROOT_REQUEST);
        SAXEmitter.emitProperties(handler, this.m_properties, namespace, prefix, true, false);
        for (AdvisorNode node : this.m_advisorNodes) {
            node.toSax(handler, namespace, prefix, node.getDefaultTag());
        }
    }

    protected String getElementNamespace(String namespace) {
        return "http://www.eclipse.org/buckminster/CQuery-1.0";
    }

    protected String getElementPrefix(String prefix) {
        return "cq";
    }

    private void setConnectContext(IConnectContext cctx) {
        this.m_connectContext = cctx;
    }
}

