/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.query.parser;

import java.net.URL;
import java.util.Map;
import org.eclipse.buckminster.core.common.parser.DocumentationHandler;
import org.eclipse.buckminster.core.common.parser.PropertyManagerHandler;
import org.eclipse.buckminster.core.cspec.parser.ComponentRequestHandler;
import org.eclipse.buckminster.core.query.builder.ComponentQueryBuilder;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.query.parser.AdvisorNodeHandler;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentQueryHandler
extends PropertyManagerHandler {
    private final URL m_contextURL;
    private DocumentationHandler m_documentationHandler;
    private AdvisorNodeHandler m_advisorNodeHandler;
    private final ComponentQueryBuilder m_builder = new ComponentQueryBuilder();

    public ComponentQueryHandler(AbstractHandler parent, URL contextURL) {
        super(parent, "componentQuery");
        this.m_contextURL = contextURL;
    }

    @Override
    public void childPopped(ChildHandler child) throws SAXException {
        if (child == this.m_advisorNodeHandler) {
            this.m_builder.addAdvisorNode(this.m_advisorNodeHandler.getAdvisorNodeBuilder());
        } else if (child == this.m_documentationHandler) {
            this.m_builder.setDocumentation(this.m_documentationHandler.createDocumentation());
        } else {
            super.childPopped(child);
        }
    }

    @Override
    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        ChildHandler ch;
        if ("rootRequest".equals(localName)) {
            ch = new ComponentRequestHandler((AbstractHandler)this, this.m_builder.getRootRequestBuilder());
        } else if ("advisorNode".equals(localName)) {
            if (this.m_advisorNodeHandler == null) {
                this.m_advisorNodeHandler = new AdvisorNodeHandler((AbstractHandler)this);
            }
            ch = this.m_advisorNodeHandler;
        } else if ("documentation".equals(localName)) {
            if (this.m_documentationHandler == null) {
                this.m_documentationHandler = new DocumentationHandler((AbstractHandler)this);
            }
            ch = this.m_documentationHandler;
        } else {
            ch = super.createHandler(uri, localName, attrs);
        }
        return ch;
    }

    public ComponentQuery getComponentQuery() throws SAXException {
        return this.m_builder.createComponentQuery();
    }

    @Override
    public Map<String, String> getProperties() {
        return this.m_builder.getDeclaredProperties();
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        this.m_builder.clear();
        this.m_builder.setContextURL(this.m_contextURL);
        this.m_builder.setPropertiesURL(ComponentQueryHandler.getOptionalStringValue((Attributes)attrs, (String)"properties"));
        this.m_builder.setResourceMapURL(ComponentQueryHandler.getOptionalStringValue((Attributes)attrs, (String)"resourceMap"));
        this.m_builder.setShortDesc(ComponentQueryHandler.getOptionalStringValue((Attributes)attrs, (String)"shortDesc"));
    }
}

