/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.reader;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.helpers.FileHandle;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.mspec.ConflictResolution;
import org.eclipse.buckminster.core.reader.AbstractReader;
import org.eclipse.buckminster.core.reader.EclipsePreferencesReader;
import org.eclipse.buckminster.core.reader.ICatalogReader;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.reader.IStreamConsumer;
import org.eclipse.buckminster.core.reader.IllegalOverlayException;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCatalogReader
extends AbstractReader
implements ICatalogReader {
    private boolean m_prefStateKnown = false;
    private IEclipsePreferences m_preferences;

    protected AbstractCatalogReader(IReaderType readerType, ProviderMatch providerMatch) {
        super(readerType, providerMatch);
    }

    @Override
    protected void copyOverlay(IPath destination, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 100);
        try {
            File addOnFolder = this.getOverlayFolder(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            if (addOnFolder != null) {
                File destDir = destination.toFile();
                destDir.mkdirs();
                FileUtils.deepCopyUnchecked(addOnFolder, destDir, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            } else {
                MonitorUtils.worked((IProgressMonitor)monitor, (int)50);
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public final boolean exists(String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 100);
        try {
            File addOnFolder = this.getOverlayFolder(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10));
            if (addOnFolder != null && new File(addOnFolder, fileName).exists()) {
                MonitorUtils.worked((IProgressMonitor)monitor, (int)90);
                return true;
            }
            boolean bl = this.innerExists(fileName, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public final FileHandle getContents(String fileName, IProgressMonitor monitor) throws CoreException, IOException {
        ProviderMatch ri = this.getProviderMatch();
        Logger logger = CorePlugin.getLogger();
        monitor.beginTask(null, 100);
        try {
            File addOnFile;
            File addOnFolder = this.getOverlayFolder(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10));
            if (addOnFolder != null && (addOnFile = new File(addOnFolder, fileName)).exists()) {
                logger.debug("Provider %s(%s): getContents will use overlay %s for file = %s", new Object[]{this.getReaderType().getId(), ri.getRepositoryURI(), addOnFile, fileName});
                MonitorUtils.worked((IProgressMonitor)monitor, (int)90);
                FileHandle fileHandle = new FileHandle(fileName, addOnFile, false);
                return fileHandle;
            }
            FileHandle fileHandle = this.innerGetContents(fileName, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
            return fileHandle;
        }
        finally {
            monitor.done();
        }
    }

    protected File getOverlayFolder(IProgressMonitor monitor) throws CoreException {
        URL overlay = this.getNodeQuery().getOverlayFolder();
        if (overlay == null) {
            MonitorUtils.complete((IProgressMonitor)monitor);
            return null;
        }
        try {
            String fos;
            File fileOverlay = FileUtils.getFile(FileLocator.toFileURL((URL)overlay));
            if (fileOverlay == null) {
                return this.obtainRemoteOverlayFolder(overlay, monitor);
            }
            if (!fileOverlay.isAbsolute()) {
                IPath wsRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                fileOverlay = wsRoot.append((IPath)new Path(fileOverlay.toString())).toFile();
            }
            if ((fos = fileOverlay.toString()).endsWith(".zip") || fos.endsWith(".jar")) {
                File dest = FileUtils.createTempFolder("bmovl", ".tmp");
                FileUtils.unzip(URLUtils.normalizeToURL((String)fos), this.getConnectContext(), null, dest, ConflictResolution.REPLACE, monitor);
                return dest;
            }
            if (!fileOverlay.isDirectory()) {
                throw new IllegalOverlayException(Messages.Only_folders_zip_and_jar_archives_allowed);
            }
            MonitorUtils.complete((IProgressMonitor)monitor);
            return fileOverlay;
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    @Override
    public final List<FileHandle> getRootFiles(Pattern matchPattern, IProgressMonitor monitor) throws CoreException, IOException {
        String[] names;
        ArrayList<FileHandle> files = new ArrayList<FileHandle>();
        monitor.beginTask(null, 100);
        File addOnFolder = this.getOverlayFolder(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10));
        if (addOnFolder != null && (names = addOnFolder.list()) != null) {
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (matchPattern.matcher(name).matches()) {
                    files.add(new FileHandle(name, new File(addOnFolder, name), false));
                }
                ++n2;
            }
        }
        this.innerGetMatchingRootFiles(matchPattern, files, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
        return files;
    }

    protected abstract boolean innerExists(String var1, IProgressMonitor var2) throws CoreException;

    protected FileHandle innerGetContents(String fileName, IProgressMonitor monitor) throws CoreException, IOException {
        FileHandle fileHandle;
        FileOutputStream tmp = null;
        File tempFile = null;
        try {
            tempFile = this.createTempFile();
            final FileOutputStream out = tmp = new FileOutputStream(tempFile);
            this.readFile(fileName, new IStreamConsumer<Object>(){

                @Override
                public Object consumeStream(IComponentReader reader, String streamName, InputStream stream, IProgressMonitor mon) throws IOException {
                    FileUtils.copyFile(stream, out, mon);
                    return null;
                }
            }, monitor);
            FileHandle fh = new FileHandle(fileName, tempFile, true);
            tempFile = null;
            fileHandle = fh;
        }
        catch (FileNotFoundException e) {
            try {
                throw BuckminsterException.wrap((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.close(tmp);
                if (tempFile != null) {
                    tempFile.delete();
                }
                throw throwable;
            }
        }
        IOUtils.close((Closeable)tmp);
        if (tempFile != null) {
            tempFile.delete();
        }
        return fileHandle;
    }

    protected void innerGetMatchingRootFiles(Pattern pattern, List<FileHandle> files, IProgressMonitor monitor) throws CoreException, IOException {
    }

    protected void innerList(List<String> files, IProgressMonitor monitor) throws CoreException {
    }

    protected abstract <T> T innerReadFile(String var1, IStreamConsumer<T> var2, IProgressMonitor var3) throws CoreException, IOException;

    @Override
    public final List<String> list(IProgressMonitor monitor) throws CoreException {
        ArrayList<String> files = new ArrayList<String>();
        this.innerList(files, monitor);
        return files;
    }

    @Override
    public final void materialize(IPath location, Resolution resolution, MaterializationContext ctx, IProgressMonitor monitor) throws CoreException {
        ProviderMatch pm = this.getProviderMatch();
        CorePlugin.getLogger().debug("Provider %s(%s): materializing to %s", new Object[]{this.getReaderType().getId(), pm.getRepositoryURI(), location});
        monitor.beginTask(null, 100);
        try {
            this.innerMaterialize(location, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)80));
            this.copyOverlay(location, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10));
        }
        finally {
            monitor.done();
        }
    }

    private File obtainRemoteOverlayFolder(URL url, IProgressMonitor monitor) throws CoreException {
        String path = url.getPath();
        if (!path.endsWith(".zip") && !path.endsWith(".jar")) {
            throw new IllegalOverlayException(Messages.Only_zip_and_jar_archives_allowed_for_remote_overlays);
        }
        File dest = FileUtils.createTempFolder("bmovl", ".tmp");
        FileUtils.unzip(url, this.getConnectContext(), null, dest, ConflictResolution.REPLACE, monitor);
        return dest;
    }

    @Override
    public synchronized IEclipsePreferences readBuckminsterPreferences(IProgressMonitor monitor) throws CoreException {
        if (this.m_prefStateKnown) {
            MonitorUtils.complete((IProgressMonitor)monitor);
            return this.m_preferences;
        }
        try {
            IEclipsePreferences iEclipsePreferences = this.m_preferences = this.readFile(EclipsePreferencesReader.BUCKMINSTER_PROJECT_PREFS_PATH, EclipsePreferencesReader.INSTANCE, monitor);
            return iEclipsePreferences;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        finally {
            this.m_prefStateKnown = true;
        }
    }

    /*
     * Loose catch block
     * WARNING - bad return control flow
     */
    @Override
    public final <T> T readFile(String fileName, IStreamConsumer<T> consumer, IProgressMonitor monitor) throws CoreException, IOException {
        MonitorUtils.begin((IProgressMonitor)monitor, (int)100);
        try {
            T t;
            T t2;
            File addOnFolder = this.getOverlayFolder(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10));
            if (addOnFolder == null) {
                T t3 = this.innerReadFile(fileName, consumer, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
                return t3;
            }
            BufferedInputStream tmp = null;
            IProgressMonitor overlayReadMon = MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10);
            try {
                File file = new File(addOnFolder, fileName);
                tmp = new BufferedInputStream(new FileInputStream(file));
                t2 = consumer.consumeStream(this, file.getAbsolutePath(), tmp, overlayReadMon);
            }
            catch (FileNotFoundException e) {
                try {
                    MonitorUtils.complete((IProgressMonitor)overlayReadMon);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    IOUtils.close(tmp);
                }
                t = this.innerReadFile(fileName, consumer, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)80));
            }
            IOUtils.close((Closeable)tmp);
            return t2;
            return t;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            MonitorUtils.done((IProgressMonitor)monitor);
        }
    }
}

