/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.reader;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IStreamConsumer;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipsePreferencesReader
implements IStreamConsumer<IEclipsePreferences> {
    public static final EclipsePreferencesReader INSTANCE = new EclipsePreferencesReader();
    public static final String BUCKMINSTER_PROJECT_PREFS_PATH = ".settings/" + CorePlugin.getID() + ".prefs";

    @Override
    public IEclipsePreferences consumeStream(IComponentReader fileReader, String streamName, InputStream stream, IProgressMonitor monitor) throws CoreException, IOException {
        monitor = MonitorUtils.ensureNotNull((IProgressMonitor)monitor);
        try {
            monitor.beginTask(null, 1);
            monitor.subTask(Messages.Loading_preferences);
            IEclipsePreferences iEclipsePreferences = ECRemotePrefs.loadFromStream(stream);
            return iEclipsePreferences;
        }
        finally {
            monitor.done();
        }
    }

    private static class ECRemotePrefs
    extends EclipsePreferences {
        private ECRemotePrefs() {
        }

        public static IEclipsePreferences loadFromStream(InputStream stream) throws IOException {
            Properties props = new Properties();
            props.load(stream);
            EclipsePreferences prefs = new EclipsePreferences();
            EclipsePreferences.convertFromProperties((EclipsePreferences)prefs, (Properties)props, (boolean)false);
            return prefs;
        }
    }
}

