/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.reader;

import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.reader.SiteFeatureReaderType;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.AbstractVersionFinder;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.VersionFactory;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.VersionedIdentifier;

public class SiteFeatureFinder
extends AbstractVersionFinder {
    private final ISite m_site;
    private final ComponentRequest m_request;

    SiteFeatureFinder(Provider provider, IComponentType ctype, NodeQuery query, IProgressMonitor monitor) throws CoreException {
        super(provider, ctype, query);
        this.m_site = SiteFeatureReaderType.getSite(provider.getURI(query.getProperties()), monitor);
        this.m_request = query.getComponentRequest();
    }

    public VersionMatch getBestVersion(IProgressMonitor monitor) throws CoreException {
        String name = this.m_request.getName();
        IVersion bestFit = null;
        ISiteFeatureReference[] iSiteFeatureReferenceArray = this.m_site.getRawFeatureReferences();
        int n = iSiteFeatureReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                ISiteFeatureReference featureRef = iSiteFeatureReferenceArray[n2];
                VersionedIdentifier versionAndId = featureRef.getVersionedIdentifier();
                if (name.equals(versionAndId.getIdentifier())) {
                    IVersion version;
                    try {
                        version = VersionFactory.OSGiType.coerce(versionAndId.getVersion());
                    }
                    catch (Exception e) {
                        break block5;
                    }
                    boolean isMatch = this.getQuery().isMatch(version, null);
                    if (isMatch && (bestFit == null || version.compareTo(bestFit) > 0)) {
                        bestFit = version;
                    }
                }
            }
            ++n2;
        }
        return bestFit == null ? null : new VersionMatch(bestFit, null, -1L, null, null);
    }
}

