/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.reader;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.reader.AbstractCatalogReader;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IFileReader;
import org.eclipse.buckminster.core.reader.IStreamConsumer;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipArchiveReader
extends AbstractCatalogReader {
    private final IFileReader m_zipFileReader;

    public ZipArchiveReader(IFileReader fileReader) {
        super(fileReader.getReaderType(), fileReader.getProviderMatch());
        this.m_zipFileReader = fileReader;
    }

    public IComponentReader getFileReader() {
        return this.m_zipFileReader;
    }

    @Override
    public void innerMaterialize(IPath destination, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException(Messages.Cannot_materialize);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean innerExists(String fileName, IProgressMonitor monitor) throws CoreException {
        ZipInputStream zi = null;
        try {
            ZipEntry ze;
            zi = new ZipInputStream(this.m_zipFileReader.open(monitor));
            while ((ze = zi.getNextEntry()) != null) {
                if (!ze.getName().equals(fileName)) continue;
                IOUtils.close((Closeable)zi);
                return true;
            }
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        finally {
            IOUtils.close(zi);
        }
        return false;
    }

    @Override
    protected void innerList(List<String> files, IProgressMonitor monitor) throws CoreException {
        block8: {
            ZipInputStream zi = null;
            try {
                try {
                    ZipEntry ze;
                    zi = new ZipInputStream(this.m_zipFileReader.open(monitor));
                    while ((ze = zi.getNextEntry()) != null) {
                        String name = ze.getName();
                        if (name.endsWith("/")) {
                            name = name.substring(name.length() - 1);
                        }
                        if (name.indexOf(47, 1) >= 0) continue;
                        if (ze.isDirectory()) {
                            name = String.valueOf(name) + "/";
                        }
                        files.add(name);
                    }
                }
                catch (IOException iOException) {
                    IOUtils.close(zi);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(zi);
                throw throwable;
            }
            IOUtils.close((Closeable)zi);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected <T> T innerReadFile(String fileName, IStreamConsumer<T> consumer, IProgressMonitor monitor) throws CoreException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[DOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

