/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.resolver;

import java.io.Closeable;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.common.model.Format;
import org.eclipse.buckminster.core.common.model.PropertyRef;
import org.eclipse.buckminster.core.cspec.QualifiedDependency;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.ComponentName;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.cspec.model.ComponentRequestConflictException;
import org.eclipse.buckminster.core.ctype.AbstractComponentType;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.ctype.MissingCSpecSourceException;
import org.eclipse.buckminster.core.metadata.MissingComponentException;
import org.eclipse.buckminster.core.metadata.StorageManager;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.BillOfMaterials;
import org.eclipse.buckminster.core.metadata.model.GeneratorNode;
import org.eclipse.buckminster.core.metadata.model.Materialization;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.metadata.model.ResolvedNode;
import org.eclipse.buckminster.core.metadata.model.UnresolvedNode;
import org.eclipse.buckminster.core.query.builder.ComponentQueryBuilder;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.resolver.IResolver;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.core.resolver.ResolverDecision;
import org.eclipse.buckminster.core.resolver.ResolverDecisionType;
import org.eclipse.buckminster.core.resolver.ResolverNode;
import org.eclipse.buckminster.core.rmap.model.BidirectionalTransformer;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.rmap.model.ProviderScore;
import org.eclipse.buckminster.core.rmap.model.VersionConverterDesc;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionFactory;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalResolver
extends HashMap<ComponentName, ResolverNode[]>
implements IResolver {
    public static final Provider INSTALLED_BUNDLE_PROVIDER;
    public static final Provider INSTALLED_FEATURE_PROVIDER;
    private final ResolutionContext m_context;
    private boolean m_recursiveResolve = true;

    static {
        VersionConverterDesc pdeConverter = new VersionConverterDesc("tag", VersionFactory.OSGiType, new BidirectionalTransformer[0]);
        INSTALLED_BUNDLE_PROVIDER = new Provider(null, "eclipse.platform", new String[]{"osgi.bundle"}, pdeConverter, new Format("plugin/${buckminster.component}"), null, null, null, false, false, null, null);
        INSTALLED_FEATURE_PROVIDER = new Provider(null, "eclipse.platform", new String[]{"eclipse.feature"}, pdeConverter, new Format("feature/${buckminster.component}"), null, null, null, false, false, null, null);
    }

    public static Resolution fromPath(IPath productPath, String name) throws CoreException {
        return LocalResolver.fromPath(productPath, name, null, (IProgressMonitor)new NullProgressMonitor());
    }

    public static Resolution fromPath(NodeQuery query, IPath path, Resolution oldInfo) throws CoreException {
        ComponentRequest request = query.getComponentRequest();
        Resolution resolution = LocalResolver.fromPath(path, request.getName(), request.getComponentTypeID(), (IProgressMonitor)new NullProgressMonitor());
        if (oldInfo != null) {
            resolution = new Resolution(resolution.getCSpec(), resolution.getOPML(), oldInfo);
        }
        return resolution;
    }

    private static Resolution fromPath(IPath productPath, String name, String givenCtypeId, IProgressMonitor monitor) throws CoreException {
        Format repoURI;
        Set<String> possibleTypes;
        if (givenCtypeId != null) {
            possibleTypes = Collections.singleton(givenCtypeId);
        } else {
            possibleTypes = new HashSet<String>();
            IComponentType[] iComponentTypeArray = AbstractComponentType.getComponentTypes();
            int n = iComponentTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IComponentType ctype = iComponentTypeArray[n2];
                if (ctype.isMetaFileBased() && ctype.hasAllRequiredMetaFiles(productPath)) {
                    possibleTypes.add(ctype.getId());
                }
                ++n2;
            }
            if (possibleTypes.isEmpty()) {
                possibleTypes.add("unknown");
            }
        }
        try {
            String repoStr = productPath.toFile().toURI().toURL().toString();
            int nameIndex = repoStr.lastIndexOf(name);
            if (nameIndex > 0) {
                String parameterized = repoStr.substring(0, nameIndex);
                parameterized = String.valueOf(parameterized) + "{0}";
                if (repoStr.length() > (nameIndex += name.length())) {
                    parameterized = String.valueOf(parameterized) + repoStr.substring(nameIndex, repoStr.length());
                }
                repoURI = new Format(parameterized);
                repoURI.addValueHolder(new PropertyRef<String>(String.class, "buckminster.component"));
            } else {
                repoURI = new Format(repoStr);
            }
        }
        catch (MalformedURLException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        ComponentRequest rq = new ComponentRequest(name, givenCtypeId, null);
        ComponentQueryBuilder queryBld = new ComponentQueryBuilder();
        queryBld.setRootRequest(rq);
        queryBld.setPlatformAgnostic(true);
        ComponentQuery cquery = queryBld.createComponentQuery();
        ResolutionContext context = new ResolutionContext(cquery);
        NodeQuery nq = new NodeQuery(context, rq, null);
        Provider provider = new Provider(null, "local", possibleTypes.toArray(new String[possibleTypes.size()]), null, repoURI, null, null, null, false, false, null, null);
        monitor.beginTask(null, possibleTypes.size() * 100);
        int largestCSpecSize = -1;
        Resolution bestMatch = null;
        for (String ctypeId : possibleTypes) {
            IComponentType ctype = CorePlugin.getDefault().getComponentType(ctypeId);
            ProviderMatch pm = new ProviderMatch(provider, ctype, VersionMatch.DEFAULT, ProviderScore.GOOD, nq);
            try {
                BOMNode node = ctype.getResolution(pm, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
                Resolution resolution = node.getResolution();
                if (resolution == null) continue;
                int imageSize = resolution.getCSpec().getImage().length;
                if (bestMatch != null && largestCSpecSize >= imageSize) continue;
                largestCSpecSize = imageSize;
                bestMatch = resolution;
            }
            catch (MissingCSpecSourceException missingCSpecSourceException) {
                // empty catch block
            }
        }
        if (bestMatch == null) {
            throw new MissingComponentException(rq.toString());
        }
        return bestMatch;
    }

    public LocalResolver(ComponentQuery componentQuery) throws CoreException {
        this(new ResolutionContext(componentQuery));
    }

    public LocalResolver(ResolutionContext context) throws CoreException {
        this.m_context = context;
    }

    @Override
    public ResolutionContext getContext() {
        return this.m_context;
    }

    @Override
    public boolean isRecursiveResolve() {
        return this.m_recursiveResolve;
    }

    @Override
    public ResolverDecision logDecision(ComponentRequest request, ResolverDecisionType decisionType, Object ... args) {
        return this.m_context.logDecision(request, decisionType, args);
    }

    @Override
    public ResolverDecision logDecision(ResolverDecisionType decisionType, Object ... args) {
        return this.m_context.logDecision(decisionType, args);
    }

    @Override
    public BillOfMaterials resolve(ComponentRequest request, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, -1);
        try {
            NodeQuery query = this.m_context.getNodeQuery(request);
            ResolverNode node = this.deepResolve(this.m_context, new HashMap<ComponentName, ResolverNode>(), new UnresolvedNode(query.getQualifiedDependency()), null, monitor);
            BillOfMaterials billOfMaterials = this.createBillOfMaterials(node);
            return billOfMaterials;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public BillOfMaterials resolve(IProgressMonitor monitor) throws CoreException {
        return this.resolve(this.m_context.getComponentQuery().getExpandedRootRequest(this.m_context), monitor);
    }

    @Override
    public BillOfMaterials resolveRemaining(BillOfMaterials bom, IProgressMonitor monitor) throws CoreException {
        if (bom.isFullyResolved()) {
            MonitorUtils.complete((IProgressMonitor)monitor);
            return bom;
        }
        monitor.beginTask(null, -1);
        try {
            ComponentQuery cquery = bom.getQuery();
            ResolutionContext context = cquery == null || cquery.equals(this.m_context.getComponentQuery()) ? this.m_context : new ResolutionContext(cquery, this.m_context);
            BillOfMaterials newBom = this.createBillOfMaterials(this.deepResolve(context, new HashMap<ComponentName, ResolverNode>(), bom, bom.getTagInfo(), monitor));
            if (!newBom.contentEqual(bom)) {
                bom = newBom;
            }
            BillOfMaterials billOfMaterials = bom;
            return billOfMaterials;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void setRecursiveResolve(boolean flag) {
        this.m_recursiveResolve = flag;
    }

    protected BOMNode localResolve(NodeQuery query, IProgressMonitor monitor) throws CoreException {
        ComponentRequest request = query.getComponentRequest();
        if (query.useMaterialization() || query.useWorkspace()) {
            try {
                Resolution res = WorkspaceInfo.getResolution(request, true);
                if (res.getProvider().getReaderTypeId().equals("eclipse.platform")) {
                    if (!query.useTargetPlatform()) {
                        res = null;
                    }
                } else {
                    Materialization mat = WorkspaceInfo.getMaterialization(res);
                    if (mat == null) {
                        res = null;
                    } else if (!query.useWorkspace() && WorkspaceInfo.getProject(mat) != null) {
                        res = null;
                    }
                }
                if (res != null && res.isFilterMatchFor(query)) {
                    MonitorUtils.complete((IProgressMonitor)monitor);
                    return new ResolvedNode(query, res);
                }
            }
            catch (MissingComponentException res) {
                // empty catch block
            }
        }
        if (query.useWorkspace()) {
            Resolution resolution;
            ComponentIdentifier ci;
            IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
            IProject existingProject = null;
            try {
                existingProject = wsRoot.getProject(request.getProjectName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (existingProject != null && existingProject.isOpen() && request.designates(ci = (resolution = LocalResolver.fromPath(query, existingProject.getLocation(), null)).getComponentIdentifier()) && resolution.isFilterMatchFor(query)) {
                StorageManager sm = StorageManager.getDefault();
                Materialization mat = new Materialization(existingProject.getLocation().addTrailingSeparator(), ci);
                mat.store(sm);
                resolution.store(sm);
                MonitorUtils.complete((IProgressMonitor)monitor);
                return new ResolvedNode(query, resolution);
            }
        }
        if (query.useTargetPlatform()) {
            Provider provider;
            String ctypeID = request.getComponentTypeID();
            if ("osgi.bundle".equals(ctypeID)) {
                provider = INSTALLED_BUNDLE_PROVIDER;
            } else if ("eclipse.feature".equals(ctypeID)) {
                provider = INSTALLED_FEATURE_PROVIDER;
            } else {
                return null;
            }
            MultiStatus problemCollector = new MultiStatus(CorePlugin.getID(), 0, "", null);
            ProviderMatch match = provider.findMatch(query, problemCollector, (IProgressMonitor)new NullProgressMonitor());
            if (match == null) {
                return null;
            }
            monitor.beginTask(null, 30);
            try {
                IComponentReader[] reader = new IComponentReader[]{match.getReader(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10))};
                BOMNode node = match.getComponentType().getResolutionBuilder(reader[0], MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10)).build(reader, false, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10));
                IOUtils.close((Closeable)reader[0]);
                Resolution res = node.getResolution();
                if (res.isFilterMatchFor(query)) {
                    res.store(StorageManager.getDefault());
                    BOMNode bOMNode = node;
                    return bOMNode;
                }
            }
            finally {
                monitor.done();
            }
        }
        return null;
    }

    BillOfMaterials createBillOfMaterials(ResolverNode topNode) throws CoreException {
        HashMap<UUID, BOMNode> nodeMap = new HashMap<UUID, BOMNode>();
        Stack<Resolution> circularDepTrap = new Stack<Resolution>();
        BOMNode node = topNode.collectNodes(nodeMap, circularDepTrap, true);
        if (node == null) {
            node = new UnresolvedNode(topNode.getQuery().getQualifiedDependency());
        }
        return BillOfMaterials.create(node, this.getContext().getComponentQuery());
    }

    ResolverNode createResolverNode(ResolutionContext context, QualifiedDependency qDep, String requestorInfo) {
        return new ResolverNode(context.getNodeQuery(qDep), requestorInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResolverNode getResolverNode(ResolutionContext context, QualifiedDependency qDep, String requestorInfo) throws CoreException {
        ResolverNode nr;
        boolean infant;
        ResolverNode[] nrs;
        ComponentRequest request = qDep.getRequest();
        ComponentName key = request.toPureComponentName();
        LocalResolver localResolver = this;
        synchronized (localResolver) {
            nrs = (ResolverNode[])this.get(key);
            boolean bl = infant = nrs == null;
            if (infant) {
                nrs = new ResolverNode[]{this.createResolverNode(context, qDep, requestorInfo)};
                this.put(key, nrs);
            }
        }
        if (infant) {
            return nrs[0];
        }
        int top = nrs.length;
        int idx = 0;
        while (idx < top) {
            try {
                nr = nrs[idx];
                nr.addDependencyQualification(qDep);
                return nr;
            }
            catch (ComponentRequestConflictException e) {
                CorePlugin.getLogger().warning(e.getMessage(), new Object[0]);
                ++idx;
            }
        }
        LocalResolver localResolver2 = this;
        synchronized (localResolver2) {
            nrs = (ResolverNode[])this.get(key);
            if (nrs.length == top) {
                nr = this.createResolverNode(context, qDep, requestorInfo);
                ResolverNode[] newNrs = new ResolverNode[top + 1];
                System.arraycopy(nrs, 0, newNrs, 0, top);
                newNrs[top] = nr;
                this.put(key, newNrs);
            } else {
                nr = null;
            }
        }
        if (nr == null) {
            nr = this.getResolverNode(context, qDep, requestorInfo);
        }
        return nr;
    }

    private ResolverNode deepResolve(ResolutionContext context, Map<ComponentName, ResolverNode> visited, BOMNode depNode, String tagInfo, IProgressMonitor monitor) throws CoreException {
        QualifiedDependency qDep = depNode.getQualifiedDependency();
        ComponentName key = qDep.getRequest().toPureComponentName();
        ResolverNode node = visited.get(key);
        if (node != null) {
            return node;
        }
        node = this.getResolverNode(context, qDep, tagInfo);
        visited.put(key, node);
        if (node.isResolved()) {
            return node;
        }
        NodeQuery query = context.getNodeQuery(qDep);
        if (query.skipComponent()) {
            return node;
        }
        GeneratorNode generatorNode = query.getResolutionContext().getGeneratorNode(qDep.getRequest().getName());
        if (generatorNode != null) {
            node.setGeneratorNode(generatorNode);
            return node;
        }
        Resolution res = depNode.getResolution();
        if (res == null) {
            block12: {
                try {
                    depNode = this.localResolve(query, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
                }
                catch (CoreException e) {
                    if (context.isContinueOnError()) break block12;
                    throw e;
                }
            }
            if (depNode == null) {
                return node;
            }
            res = depNode.getResolution();
            if (res == null) {
                return node;
            }
        }
        if ((context = node.startResolvingChildren(depNode)) == null) {
            return node;
        }
        List<BOMNode> children = depNode.getChildren();
        int top = children.size();
        if (top == 0) {
            node.setResolution(res, null);
            return node;
        }
        ResolverNode[] resolvedChildren = new ResolverNode[top];
        String childTagInfo = res.getCSpec().getTagInfo(tagInfo);
        int idx = 0;
        while (idx < top) {
            BOMNode child = children.get(idx);
            ComponentQuery cquery = child.getQuery();
            ResolutionContext childContext = cquery == null ? context : new ResolutionContext(cquery, context);
            resolvedChildren[idx] = this.m_recursiveResolve ? this.deepResolve(childContext, visited, child, childTagInfo, monitor) : this.getResolverNode(childContext, child.getQualifiedDependency(), childTagInfo);
            ++idx;
        }
        node.setResolution(res, resolvedChildren);
        return node;
    }
}

