/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.resolver;

import java.net.URL;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.QualifiedDependency;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.helpers.UnmodifiableMapUnion;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.resolver.IResolverBackchannel;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.core.resolver.ResolverDecision;
import org.eclipse.buckminster.core.resolver.ResolverDecisionType;
import org.eclipse.buckminster.core.rmap.model.ProviderScore;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.IVersionDesignator;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeQuery
implements Comparator<VersionMatch>,
IResolverBackchannel {
    private final RMContext m_context;
    private final Map<String, ? extends Object> m_properties;
    private final QualifiedDependency m_qDep;
    private transient IComponentType m_componentType;

    public NodeQuery(NodeQuery query, Map<String, ? extends Object> additionalProperties) {
        this.m_context = query.getContext();
        this.m_qDep = query.getQualifiedDependency();
        this.m_properties = new UnmodifiableMapUnion<String, Object>(additionalProperties, query.getProperties());
    }

    public NodeQuery(RMContext context, ComponentRequest request, Set<String> attributes) {
        this(context, new QualifiedDependency(request, attributes));
    }

    public NodeQuery(RMContext context, QualifiedDependency qDep) {
        this.m_context = context;
        this.m_qDep = qDep;
        this.m_properties = context.getProperties(qDep.getRequest());
    }

    public NodeQuery addDependencyQualification(QualifiedDependency newQDep) throws CoreException {
        QualifiedDependency qDep = this.m_qDep.mergeDependency(newQDep);
        return qDep == this.m_qDep ? this : this.m_context.getNodeQuery(qDep);
    }

    public boolean allowCircularDependency() throws CoreException {
        return this.getComponentQuery().allowCircularDependency(this.getComponentRequest());
    }

    @Override
    public int compare(VersionMatch vm1, VersionMatch vm2) {
        if (vm1 == vm2) {
            return 0;
        }
        int cmp = 0;
        long revision = this.getRevision();
        long vm1Rev = vm1.getRevision();
        long vm2Rev = vm2.getRevision();
        if (revision != -1L) {
            if (vm1Rev != -1L && revision >= vm1Rev) {
                if (vm2Rev == -1L || revision < vm2Rev) {
                    cmp = 1;
                }
            } else {
                if (vm2Rev != -1L && revision >= vm2Rev) {
                    cmp = -1;
                }
                return 0;
            }
        }
        if (cmp != 0) {
            return cmp;
        }
        Date timestamp = this.getTimestamp();
        Date vm1Ts = vm1.getTimestamp();
        Date vm2Ts = vm2.getTimestamp();
        if (timestamp != null) {
            if (vm1Ts != null && timestamp.compareTo(vm1Ts) >= 0) {
                if (vm2Ts == null || timestamp.compareTo(vm2Ts) < 0) {
                    cmp = 1;
                }
            } else {
                if (vm2Ts != null && timestamp.compareTo(vm2Ts) >= 0) {
                    cmp = -1;
                }
                return 0;
            }
        }
        if (cmp != 0) {
            return cmp;
        }
        int[] prio = this.getResolutionPrio();
        int idx = 0;
        while (idx < prio.length) {
            switch (prio[idx]) {
                case 2: {
                    cmp = this.compareSelectors(vm1, vm2);
                    break;
                }
                default: {
                    cmp = this.compareVersions(vm1, vm2);
                }
            }
            if (cmp != 0) {
                return cmp;
            }
            ++idx;
        }
        if (vm1Rev != -1L && vm2Rev != -1L && vm1Rev != vm2Rev) {
            return vm1Rev < vm2Rev ? -1 : 1;
        }
        if (vm1Ts != null && vm2Ts != null) {
            cmp = vm1Ts.compareTo(vm2Ts);
        }
        return cmp;
    }

    public IAttribute[] getAttributes(CSpec cspec) throws CoreException {
        return cspec.getAttributes(this.getRequiredAttributes());
    }

    public VersionSelector[] getBranchTagPath() {
        return this.getComponentQuery().getBranchTagPath(this.getComponentRequest());
    }

    public final ComponentQuery getComponentQuery() {
        return this.m_context.getComponentQuery();
    }

    public final ComponentRequest getComponentRequest() {
        return this.m_qDep.getRequest();
    }

    public synchronized IComponentType getComponentType() {
        if (this.m_componentType == null) {
            try {
                this.m_componentType = this.getComponentRequest().getComponentType();
            }
            catch (CoreException e) {
                throw new IllegalStateException(Messages.Unable_to_obtain_component_type, e);
            }
        }
        return this.m_componentType;
    }

    public RMContext getContext() {
        return this.m_context;
    }

    public final URL getOverlayFolder() {
        return this.getComponentQuery().getOverlayFolder(this.getComponentRequest());
    }

    public Map<String, ? extends Object> getProperties() {
        return this.m_properties;
    }

    public Object getProperty(String mapName) {
        return this.getProperties().get(mapName);
    }

    public ProviderScore getProviderScore(boolean mutable, boolean source) {
        return this.getComponentQuery().getProviderScore(this.getComponentRequest(), mutable, source);
    }

    public QualifiedDependency getQualifiedDependency() {
        return this.m_qDep;
    }

    public List<String> getRequiredAttributes() {
        return this.getComponentQuery().getAttributes(this.getComponentRequest());
    }

    public ResolutionContext getResolutionContext() {
        if (this.m_context instanceof ResolutionContext) {
            return (ResolutionContext)this.m_context;
        }
        throw new IllegalStateException(Messages.ResolutionContext_requested_during_Materialization);
    }

    public int[] getResolutionPrio() {
        return this.getComponentQuery().getResolutionPrio(this.getComponentRequest());
    }

    public long getRevision() {
        return this.getComponentQuery().getRevision(this.getComponentRequest());
    }

    public Date getTimestamp() {
        return this.getComponentQuery().getTimestamp(this.getComponentRequest());
    }

    public IVersionDesignator getVersionDesignator() {
        ComponentRequest request = this.getComponentRequest();
        IVersionDesignator vds = this.getComponentQuery().getVersionOverride(request);
        if (vds == null) {
            vds = request.getVersionDesignator();
        }
        if (vds == null) {
            return vds;
        }
        IComponentType ctype = this.getComponentType();
        if (ctype == null && "Triplet".equals(vds.getVersion().getType().getId())) {
            try {
                ctype = CorePlugin.getDefault().getComponentType("maven");
            }
            catch (CoreException e) {
                return vds;
            }
        }
        return ctype == null ? vds : ctype.getTypeSpecificDesignator(vds);
    }

    public boolean isMatch(IVersion version, VersionSelector branchOrTag) {
        IVersionDesignator designator;
        VersionSelector[] branchTagPath = this.getBranchTagPath();
        if (branchTagPath.length > 0) {
            if (branchOrTag == null) {
                branchOrTag = VersionSelector.branch("main");
            }
            if (VersionSelector.indexOf(branchTagPath, branchOrTag) < 0) {
                this.logDecision(branchOrTag == null || branchOrTag.getType() == 0 ? ResolverDecisionType.BRANCH_REJECTED : ResolverDecisionType.TAG_REJECTED, branchOrTag, NLS.bind((String)Messages.Not_in_path_0, (Object)VersionSelector.toString(branchTagPath)));
                return false;
            }
        }
        if ((designator = this.getVersionDesignator()) != null && !designator.designates(version)) {
            this.logDecision(ResolverDecisionType.VERSION_REJECTED, version, NLS.bind((String)Messages.Not_designated_by_0, (Object)designator));
            return false;
        }
        return true;
    }

    public boolean isMatch(VersionMatch versionMatch) {
        if (versionMatch == null) {
            versionMatch = VersionMatch.DEFAULT;
        }
        return this.isMatch(versionMatch.getVersion(), versionMatch.getBranchOrTag());
    }

    public boolean isPrune() {
        return this.getComponentQuery().isPrune(this.getComponentRequest());
    }

    @Override
    public ResolverDecision logDecision(ComponentRequest request, ResolverDecisionType decisionType, Object ... args) {
        return this.getResolutionContext().logDecision(request, decisionType, args);
    }

    @Override
    public ResolverDecision logDecision(ResolverDecisionType decisionType, Object ... args) {
        return this.getResolutionContext().logDecision(this.getComponentRequest(), decisionType, args);
    }

    public boolean skipComponent() {
        return this.getComponentQuery().skipComponent(this.getComponentRequest());
    }

    public boolean useMaterialization() {
        return this.getComponentQuery().useMaterialization(this.getComponentRequest());
    }

    public boolean useResolutionService() {
        return this.getComponentQuery().useResolutionService(this.getComponentRequest());
    }

    public boolean useTargetPlatform() {
        return this.getComponentQuery().useTargetPlatform(this.getComponentRequest());
    }

    public boolean useWorkspace() {
        return this.getComponentQuery().useWorkspace(this.getComponentRequest());
    }

    private int compareSelectors(VersionMatch vm1, VersionMatch vm2) {
        int cmp = 0;
        VersionSelector[] branchTagPath = this.getBranchTagPath();
        if (branchTagPath.length > 0) {
            int v1idx = VersionSelector.indexOf(branchTagPath, vm1.getBranchOrTag());
            int v2idx = VersionSelector.indexOf(branchTagPath, vm2.getBranchOrTag());
            if (v1idx >= 0) {
                cmp = v2idx >= 0 ? (v1idx < v2idx ? 1 : (v1idx == v2idx ? 0 : -1)) : 1;
            } else if (v2idx >= 0) {
                cmp = -1;
            }
        }
        return cmp;
    }

    private int compareVersions(VersionMatch vm1, VersionMatch vm2) {
        IVersion v1 = vm1.getVersion();
        IVersion v2 = vm2.getVersion();
        IVersionDesignator vd = this.getVersionDesignator();
        if (vd != null) {
            if (v1 != null && !vd.designates(v1)) {
                v1 = null;
            }
            if (v2 != null && !vd.designates(v2)) {
                v2 = null;
            }
        }
        int cmp = 0;
        if (v1 == null) {
            if (v2 != null) {
                cmp = -1;
            }
        } else if (v2 == null) {
            cmp = 1;
        } else if (v1.getType().isComparableTo(v2.getType())) {
            cmp = v1.compareTo(v2);
        }
        return cmp;
    }
}

