/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.IPrerequisite;
import org.eclipse.buckminster.core.cspec.QualifiedDependency;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.TopLevelAttributeBuilder;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.CircularDependencyException;
import org.eclipse.buckminster.core.cspec.model.Generator;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.BillOfMaterials;
import org.eclipse.buckminster.core.metadata.model.GeneratorNode;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.metadata.model.ResolvedNode;
import org.eclipse.buckminster.core.metadata.model.UnresolvedNode;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.core.version.IVersionDesignator;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolverNode {
    private static final ResolverNode[] s_noChildren = new ResolverNode[0];
    private ResolverNode[] m_children;
    private GeneratorNode m_generatorNode;
    private boolean m_invalidateRun;
    private NodeQuery m_query;
    private Resolution m_resolution;
    private String m_tagInfo;

    public ResolverNode(NodeQuery query, String tagInfo) {
        this.m_query = query;
        this.m_children = s_noChildren;
        this.m_tagInfo = tagInfo;
        if (tagInfo != null) {
            query.getContext().addTagInfo(query.getComponentRequest(), tagInfo);
        }
    }

    public synchronized void addDependencyQualification(QualifiedDependency newQDep) throws CoreException {
        NodeQuery query = this.m_query.addDependencyQualification(newQDep);
        if (query == this.m_query) {
            return;
        }
        IVersionDesignator newVd = query.getVersionDesignator();
        if (this.m_resolution != null && (newVd == null || newVd.designates(this.m_resolution.getVersion())) && this.m_query.getQualifiedDependency().hasAllAttributes(query.getRequiredAttributes())) {
            this.m_query = query;
            return;
        }
        this.m_resolution = null;
        this.m_children = s_noChildren;
        this.m_query = query;
        this.m_invalidateRun = true;
    }

    synchronized void clearInvalidationFlag() {
        this.m_invalidateRun = false;
    }

    public BOMNode collectNodes(Map<UUID, BOMNode> nodeMap, Stack<Resolution> circularDepTrap, boolean sameTop) throws CoreException {
        List<BOMNode> childNodes;
        if (this.m_query.skipComponent()) {
            return null;
        }
        if (this.m_generatorNode != null) {
            return this.m_generatorNode;
        }
        if (this.m_resolution == null) {
            return new UnresolvedNode(this.m_query.getQualifiedDependency());
        }
        UUID myID = this.m_resolution.getId();
        BOMNode node = nodeMap.get(myID);
        if (node != null) {
            return node;
        }
        if (circularDepTrap.contains(this.m_resolution)) {
            if (this.m_query.allowCircularDependency()) {
                return null;
            }
            ArrayList<String> attrs = new ArrayList<String>(circularDepTrap.size());
            for (Resolution res : circularDepTrap) {
                attrs.add(res.getCSpec().getName());
            }
            attrs.add(this.m_resolution.getName());
            throw new CircularDependencyException(attrs);
        }
        int top = this.m_children.length;
        ComponentQuery cquery = this.m_query.getComponentQuery();
        if (top > 0) {
            try {
                ArrayList<BOMNode> childNodeArr = new ArrayList<BOMNode>(top);
                circularDepTrap.push(this.m_resolution);
                ResolverNode[] resolverNodeArray = this.m_children;
                int n = this.m_children.length;
                int n2 = 0;
                while (n2 < n) {
                    ResolverNode child = resolverNodeArray[n2];
                    boolean sameChildTop = cquery.equals(child.m_query.getComponentQuery());
                    BOMNode childNode = child.collectNodes(nodeMap, circularDepTrap, sameChildTop);
                    if (childNode == null) {
                        String depName = child.getQuery().getComponentRequest().getName();
                        CSpec cspec = this.m_resolution.getCSpec();
                        CSpecBuilder bld = new CSpecBuilder();
                        bld.initFrom(cspec);
                        for (IAttribute iAttribute : cspec.getAttributes().values()) {
                            for (IPrerequisite iPrerequisite : iAttribute.getPrerequisites()) {
                                if (!depName.equals(iPrerequisite.getComponentName())) continue;
                                ((TopLevelAttributeBuilder)bld.getAttribute(iAttribute.getName())).removePrerequisite(iPrerequisite);
                            }
                        }
                        bld.removeDependency(depName);
                        cspec = bld.createCSpec();
                        this.m_resolution = new Resolution(cspec, this.m_resolution.getOPML(), this.m_resolution);
                    } else {
                        childNodeArr.add(childNode);
                    }
                    ++n2;
                }
                circularDepTrap.pop();
                childNodes = childNodeArr;
            }
            catch (CircularDependencyException e) {
                if (this.m_query.allowCircularDependency()) {
                    return null;
                }
                throw e;
            }
        } else {
            childNodes = Collections.emptyList();
        }
        node = new ResolvedNode(this.m_resolution, childNodes);
        if (!sameTop) {
            node = BillOfMaterials.create(node, cquery);
        }
        nodeMap.put(myID, node);
        return node;
    }

    NodeQuery getQuery() {
        return this.m_query;
    }

    String getTagInfo() {
        return this.m_tagInfo;
    }

    boolean isInvalidated() {
        return this.m_invalidateRun;
    }

    public boolean isResolved() {
        return this.m_resolution != null;
    }

    void setGeneratorNode(GeneratorNode generatorNode) {
        this.m_generatorNode = generatorNode;
    }

    void setQuery(NodeQuery query) {
        this.m_query = query;
    }

    public synchronized void setResolution(Resolution resolution, ResolverNode[] children) {
        if (!this.m_invalidateRun) {
            this.m_resolution = resolution;
            this.m_children = children == null ? s_noChildren : children;
        }
    }

    public synchronized ResolutionContext startResolvingChildren(BOMNode node) throws CoreException {
        CSpec cspec;
        Map<String, Generator> generators;
        ResolutionContext originalContext;
        Resolution resolution = node.getResolution();
        if (this.m_invalidateRun || resolution == null) {
            return null;
        }
        ComponentQuery cquery = node.getQuery();
        ResolutionContext context = originalContext = this.m_query.getResolutionContext();
        if (cquery != null && !cquery.equals(context.getComponentQuery())) {
            context = new ResolutionContext(cquery, context);
        }
        if ((generators = (cspec = resolution.getCSpec()).getGenerators()).size() > 0) {
            if (context == originalContext) {
                context = new ResolutionContext(originalContext.getComponentQuery(), originalContext);
            }
            context.setGenerators(cspec, generators.values());
        }
        if (context != originalContext) {
            this.m_query = context.getNodeQuery(this.m_query.getQualifiedDependency());
        }
        return context;
    }
}

