/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.resolver;

import java.util.List;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.cspec.QualifiedDependency;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.GeneratorNode;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.core.resolver.ResolverNode;
import org.eclipse.buckminster.core.resolver.ResourceMapResolver;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

class ResolverNodeWithJob
extends ResolverNode {
    private final ResourceMapResolver m_resolver;
    private final NodeResolutionJob m_job;

    ResolverNodeWithJob(ResourceMapResolver resolver, ResolutionContext context, QualifiedDependency qDep, String requestorInfo) {
        super(context.getNodeQuery(qDep), requestorInfo);
        this.m_job = new NodeResolutionJob(qDep.getRequest().toString());
        this.m_resolver = resolver;
    }

    public synchronized void addDependencyQualification(QualifiedDependency newQDep) throws CoreException {
        super.addDependencyQualification(newQDep);
        if (this.isInvalidated() && !this.isScheduled()) {
            this.m_resolver.schedule(this);
        }
    }

    private boolean buildTree(BOMNode node) throws CoreException {
        if (this.isInvalidated()) {
            return false;
        }
        ResolutionContext context = this.getQuery().getResolutionContext();
        GeneratorNode generatorNode = context.getGeneratorNode(node.getRequest().getName());
        if (generatorNode != null) {
            this.setGeneratorNode(generatorNode);
            return false;
        }
        Resolution resolution = node.getResolution();
        if (resolution == null) {
            return this.m_resolver.schedule(this);
        }
        context = this.startResolvingChildren(node);
        if (context == null) {
            return false;
        }
        List<BOMNode> nodeChildren = node.getChildren();
        int top = nodeChildren.size();
        if (top == 0) {
            this.setResolution(resolution, null);
            return false;
        }
        String tagInfo = resolution.getCSpec().getTagInfo(this.getTagInfo());
        ResolverNode[] children = new ResolverNode[top];
        boolean didSchedule = false;
        int idx = 0;
        while (idx < top) {
            ResolverNode child;
            if (this.isInvalidated()) {
                return false;
            }
            BOMNode childNode = nodeChildren.get(idx);
            ComponentQuery childQuery = childNode.getQuery();
            ResolutionContext childContext = childQuery == null ? context : new ResolutionContext(childQuery, context);
            children[idx] = child = this.m_resolver.getResolverNode(childContext, childNode.getQualifiedDependency(), tagInfo);
            if (((ResolverNodeWithJob)child).buildTree(childNode)) {
                didSchedule = true;
            }
            ++idx;
        }
        this.setResolution(resolution, children);
        return didSchedule;
    }

    NodeResolutionJob getJob() {
        return this.m_job;
    }

    boolean isScheduled() {
        return this.m_job.isScheduled();
    }

    boolean rebuildTree(BOMNode node) throws CoreException {
        this.clearInvalidationFlag();
        return this.buildTree(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BOMNode resolve(IProgressMonitor monitor) throws CoreException {
        NodeQuery query;
        ResolverNodeWithJob resolverNodeWithJob = this;
        synchronized (resolverNodeWithJob) {
            query = this.getQuery();
            if (query.skipComponent() || this.isResolved()) {
                MonitorUtils.complete((IProgressMonitor)monitor);
                return null;
            }
        }
        if (this.isInvalidated()) {
            return null;
        }
        return this.m_resolver.innerResolve(query, monitor);
    }

    /*
     * Loose catch block
     */
    protected IStatus run(IProgressMonitor monitor) {
        block15: {
            this.clearInvalidationFlag();
            this.m_resolver.addJobMonitor(monitor);
            BOMNode node = null;
            try {
                try {
                    node = this.resolve(monitor);
                    if (node != null) {
                        this.m_resolver.resolutionPartDone();
                        this.buildTree(node);
                    }
                }
                catch (CoreException e) {
                    ResolutionContext context = this.m_resolver.getContext();
                    ((RMContext)context).addRequestStatus(this.getQuery().getComponentRequest(), e.getStatus());
                    if (!((RMContext)context).isContinueOnError()) {
                        this.m_resolver.cancelTopMonitor();
                    }
                    this.m_resolver.removeJobMonitor(monitor);
                    if (node == null) {
                        this.m_resolver.resolutionPartDone();
                    }
                }
                catch (OperationCanceledException e) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    this.m_resolver.removeJobMonitor(monitor);
                    if (node == null) {
                        this.m_resolver.resolutionPartDone();
                    }
                    return iStatus;
                }
                catch (Throwable e) {
                    CorePlugin.getLogger().warning(e, e.toString(), new Object[0]);
                    this.m_resolver.getContext().addRequestStatus(this.getQuery().getComponentRequest(), BuckminsterException.wrap((Throwable)e).getStatus());
                    this.m_resolver.removeJobMonitor(monitor);
                    if (node == null) {
                        this.m_resolver.resolutionPartDone();
                    }
                    break block15;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                this.m_resolver.removeJobMonitor(monitor);
                if (node == null) {
                    this.m_resolver.resolutionPartDone();
                }
            }
        }
        return Status.OK_STATUS;
    }

    void setScheduled(boolean scheduled) {
        this.m_job.setScheduled(scheduled);
    }

    class NodeResolutionJob
    extends Job {
        private boolean m_scheduled;

        NodeResolutionJob(String name) {
            super(name);
        }

        public boolean belongsTo(Object family) {
            return family == ResolverNodeWithJob.this.m_resolver;
        }

        ResolverNodeWithJob getNode() {
            return ResolverNodeWithJob.this;
        }

        boolean isScheduled() {
            return this.m_scheduled;
        }

        protected IStatus run(IProgressMonitor monitor) {
            return ResolverNodeWithJob.this.run(monitor);
        }

        void setScheduled(boolean flag) {
            this.m_scheduled = flag;
        }
    }
}

