/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.rmap.model;

import java.util.regex.Pattern;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.ResourceMap;
import org.eclipse.buckminster.core.rmap.model.SearchPath;
import org.eclipse.buckminster.sax.AbstractSaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class Matcher
extends AbstractSaxableElement {
    public static final String ATTR_PATTERN = "pattern";
    private final ResourceMap m_owner;
    private final Pattern m_pattern;

    public Matcher(ResourceMap owner, String pattern) {
        this.m_owner = owner;
        this.m_pattern = Pattern.compile(pattern);
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_PATTERN, (String)this.m_pattern.toString());
    }

    public final ResourceMap getOwner() {
        return this.m_owner;
    }

    public final Pattern getPattern() {
        return this.m_pattern;
    }

    public abstract SearchPath getSearchPath(NodeQuery var1) throws CoreException;

    public final boolean matches(String componentName) {
        return this.m_pattern.matcher(componentName).find();
    }
}

