/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.rmap.model;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.common.model.Format;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.ctype.MissingCSpecSourceException;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.metadata.ReferentialIntegrityException;
import org.eclipse.buckminster.core.metadata.StorageManager;
import org.eclipse.buckminster.core.metadata.model.IUUIDPersisted;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.reader.IVersionFinder;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolverDecision;
import org.eclipse.buckminster.core.resolver.ResolverDecisionType;
import org.eclipse.buckminster.core.rmap.model.ProviderScore;
import org.eclipse.buckminster.core.rmap.model.SearchPath;
import org.eclipse.buckminster.core.rmap.model.URIMatcher;
import org.eclipse.buckminster.core.rmap.model.VersionConverterDesc;
import org.eclipse.buckminster.core.version.IVersionConverter;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.sax.UUIDKeyed;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Provider
extends UUIDKeyed
implements IUUIDPersisted {
    public static final String ATTR_COMPONENT_TYPES = "componentTypes";
    public static final String ATTR_ALGORITHM = "algorithm";
    public static final String ATTR_MUTABLE = "mutable";
    public static final String ATTR_READER_TYPE = "readerType";
    public static final String ATTR_RESOLUTION_FILTER = "resolutionFilter";
    public static final String ATTR_SOURCE = "source";
    public static final String ATTR_VERSION_CONVERTER = "versionConverter";
    public static final String TAG = "provider";
    public static final String TAG_URI = "uri";
    public static final int SEQUENCE_NUMBER = 2;
    public static final String TAG_DIGEST = "digest";
    private final Documentation m_documentation;
    private final String[] m_componentTypeIDs;
    private final boolean m_mutable;
    private final String m_readerTypeId;
    private final boolean m_source;
    private final Format m_uri;
    private final Format m_digest;
    private final String m_digestAlgorithm;
    private final VersionConverterDesc m_versionConverter;
    private final SearchPath m_searchPath;
    private final URIMatcher m_uriMatcher;
    private final Filter m_resolutionFilter;

    public Provider(SearchPath searchPath, String remoteReaderType, String[] componentTypeIDs, VersionConverterDesc versionConverterDesc, Format uri, Format digest, String digestAlgorithm, Filter resolutionFilter, boolean mutable, boolean source, URIMatcher uriMatcher, Documentation documentation) {
        this.m_searchPath = searchPath;
        this.m_readerTypeId = remoteReaderType;
        this.m_componentTypeIDs = componentTypeIDs == null ? Trivial.EMPTY_STRING_ARRAY : componentTypeIDs;
        this.m_versionConverter = versionConverterDesc;
        this.m_uri = uri;
        this.m_digest = digest;
        this.m_digestAlgorithm = digestAlgorithm;
        this.m_resolutionFilter = resolutionFilter;
        this.m_mutable = mutable;
        this.m_source = source;
        this.m_uriMatcher = uriMatcher;
        this.m_documentation = documentation;
    }

    public Provider(String remoteReaderType, String[] componentTypeIDs, String uri, Filter resolutionFilter) {
        this(null, remoteReaderType, componentTypeIDs, null, new Format(uri), null, null, resolutionFilter, false, false, null, null);
    }

    public void addPrefixMappings(HashMap<String, String> prefixMappings) {
        prefixMappings.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ProviderMatch findMatch(NodeQuery query, MultiStatus problemCollector, IProgressMonitor monitor) throws CoreException {
        String readerType = this.getReaderTypeId();
        ProviderScore score = query.getProviderScore(this.isMutable(), this.hasSource());
        if (score == ProviderScore.REJECTED) {
            ResolverDecision decision = query.logDecision(ResolverDecisionType.REJECTING_PROVIDER, new Object[]{readerType, this.getURI(), Messages.Score_is_below_threshold});
            problemCollector.add((IStatus)new Status(4, CorePlugin.getID(), 0, decision.toString(), null));
            return null;
        }
        if (this.m_uriMatcher != null) {
            return this.m_uriMatcher.getMatch(this, query, monitor);
        }
        IVersionFinder versionFinder = null;
        monitor.beginTask(null, 120);
        try {
            ComponentRequest request = query.getComponentRequest();
            String componentTypeID = request.getComponentTypeID();
            IComponentType[] componentTypes = this.getComponentTypes();
            if (componentTypeID != null) {
                boolean found = false;
                int idx = componentTypes.length;
                while (--idx >= 0) {
                    IComponentType ctype = componentTypes[idx];
                    if (!ctype.getId().equals(componentTypeID)) continue;
                    componentTypes = new IComponentType[]{ctype};
                    found = true;
                    break;
                }
                if (!found) {
                    if (!this.getReaderTypeId().equals("eclipse.platform")) {
                        ResolverDecision decision = query.logDecision(ResolverDecisionType.REJECTING_PROVIDER, new Object[]{readerType, this.getURI(), String.format(NLS.bind((String)Messages.Components_of_type_0_are_not_supported, (Object)componentTypeID), new Object[0])});
                        problemCollector.add((IStatus)new Status(4, CorePlugin.getID(), 0, decision.toString(), null));
                    }
                    return null;
                }
            }
            VersionMatch candidate = null;
            IComponentType ctypeUsed = null;
            CoreException problem = null;
            try {
                IComponentType[] iComponentTypeArray = componentTypes;
                int n = componentTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    block18: {
                        IComponentType ctype = iComponentTypeArray[n2];
                        try {
                            versionFinder = this.getReaderType().getVersionFinder(this, ctype, query, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)20));
                            candidate = versionFinder.getBestVersion(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)80));
                            if (candidate == null) break block18;
                            ctypeUsed = ctype;
                            break;
                        }
                        catch (MissingCSpecSourceException missingCSpecSourceException) {
                            // empty catch block
                        }
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                problem = e;
            }
            if (candidate == null) {
                ResolverDecision decision = query.logDecision(ResolverDecisionType.REJECTING_PROVIDER, new Object[]{readerType, this.getURI(), Messages.No_component_match_was_found});
                problemCollector.add((IStatus)new Status(4, CorePlugin.getID(), 0, decision.toString(), problem == null ? null : BuckminsterException.unwind((Throwable)problem)));
                return null;
            }
            query.logDecision(ResolverDecisionType.MATCH_FOUND, new Object[]{candidate});
            ProviderMatch providerMatch = versionFinder.getProviderMatch(candidate, ctypeUsed, score);
            return providerMatch;
        }
        finally {
            if (versionFinder != null) {
                versionFinder.close();
            }
            monitor.done();
        }
    }

    public final String[] getComponentTypeIDs() {
        return this.m_componentTypeIDs;
    }

    public final IComponentType[] getComponentTypes() throws CoreException {
        CorePlugin plugin = CorePlugin.getDefault();
        int idx = this.m_componentTypeIDs.length;
        IComponentType[] ctypes = new IComponentType[idx];
        while (--idx >= 0) {
            ctypes[idx] = plugin.getComponentType(this.m_componentTypeIDs[idx]);
        }
        return ctypes;
    }

    public IConnectContext getConnectContext() {
        return null;
    }

    public String getDefaultTag() {
        return TAG;
    }

    public final String getDigest(Map<String, String> properties) {
        return this.m_digest == null ? null : (String)this.m_digest.getValue(this.getProperties(properties));
    }

    public final String getDigestAlgorithm() {
        return this.m_digestAlgorithm;
    }

    public Documentation getDocumentation() {
        return this.m_documentation;
    }

    public Map<String, ? extends Object> getProperties(Map<String, ? extends Object> properties) {
        if (this.m_searchPath != null) {
            properties = this.m_searchPath.getResourceMap().getProperties(properties);
        }
        return properties;
    }

    public final IReaderType getReaderType() throws CoreException {
        return CorePlugin.getDefault().getReaderType(this.m_readerTypeId);
    }

    public final String getReaderTypeId() {
        return this.m_readerTypeId;
    }

    public Filter getResolutionFilter() {
        return this.m_resolutionFilter;
    }

    public final SearchPath getSearchPath() {
        return this.m_searchPath;
    }

    public final Format getURI() {
        return this.m_uri;
    }

    public final String getURI(Map<String, ? extends Object> properties) {
        return (String)this.m_uri.getValue(this.getProperties(properties));
    }

    public URIMatcher getURIMatcher() {
        return this.m_uriMatcher;
    }

    public IVersionConverter getVersionConverter() throws CoreException {
        VersionConverterDesc vcd = this.getVersionConverterDesc();
        return vcd == null ? null : vcd.getVersionConverter();
    }

    public final VersionConverterDesc getVersionConverterDesc() {
        return this.m_versionConverter;
    }

    public final boolean hasSource() {
        return this.m_source;
    }

    public final boolean isMutable() {
        return this.m_mutable;
    }

    @Override
    public boolean isPersisted(StorageManager sm) throws CoreException {
        return sm.getProviders().contains(this);
    }

    @Override
    public void remove(StorageManager sm) throws CoreException {
        UUID thisId = this.getId();
        if (!sm.getResolutions().getReferencingKeys(thisId, "providerId").isEmpty()) {
            throw new ReferentialIntegrityException(this, "remove", Messages.Referenced_from_Resolution);
        }
        sm.getProviders().removeElement(thisId);
    }

    @Override
    public void store(StorageManager sm) throws CoreException {
        sm.getProviders().putElement(this);
    }

    public void toSax(ContentHandler handler) throws SAXException {
        handler.startDocument();
        HashMap<String, String> prefixMappings = new HashMap<String, String>();
        this.addPrefixMappings(prefixMappings);
        for (Map.Entry<String, String> pfxMapping : prefixMappings.entrySet()) {
            handler.startPrefixMapping(pfxMapping.getKey(), pfxMapping.getValue());
        }
        this.toSax(handler, "http://www.eclipse.org/buckminster/RMap-1.0", "rm", this.getDefaultTag());
        for (String pfx : prefixMappings.keySet()) {
            handler.endPrefixMapping(pfx);
        }
        handler.endDocument();
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_READER_TYPE, (String)this.m_readerTypeId);
        if (this.m_componentTypeIDs.length > 0) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_COMPONENT_TYPES, (String)TextUtils.concat(this.m_componentTypeIDs, ","));
        }
        if (this.m_resolutionFilter != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_RESOLUTION_FILTER, (String)this.m_resolutionFilter.toString());
        }
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_MUTABLE, (String)Boolean.toString(this.m_mutable));
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_SOURCE, (String)Boolean.toString(this.m_source));
    }

    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        if (this.m_documentation != null) {
            this.m_documentation.toSax(handler, namespace, prefix, this.m_documentation.getDefaultTag());
        }
        if (this.m_uriMatcher != null) {
            this.m_uriMatcher.toSax(handler, namespace, prefix, this.m_uriMatcher.getDefaultTag());
        }
        this.m_uri.toSax(handler, namespace, prefix, TAG_URI);
        if (this.m_digest != null) {
            AttributesImpl attrs = new AttributesImpl();
            Utils.addAttribute((AttributesImpl)attrs, (String)"format", (String)this.m_digest.getFormat());
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_ALGORITHM, (String)this.m_digestAlgorithm);
            String qName = Utils.makeQualifiedName((String)prefix, (String)TAG_DIGEST);
            handler.startElement(namespace, TAG_DIGEST, qName, attrs);
            handler.endElement(namespace, TAG_DIGEST, qName);
        }
        if (this.m_versionConverter != null) {
            this.m_versionConverter.toSax(handler, namespace, prefix, this.m_versionConverter.getDefaultTag());
        }
    }

    protected String getElementNamespace(String namespace) {
        return "http://www.eclipse.org/buckminster/RMap-1.0";
    }

    protected String getElementPrefix(String prefix) {
        return "rm";
    }
}

