/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.rmap.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolverDecisionType;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.rmap.model.ProviderScore;
import org.eclipse.buckminster.core.rmap.model.ResourceMap;
import org.eclipse.buckminster.core.version.IVersionDesignator;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.sax.AbstractSaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchPath
extends AbstractSaxableElement {
    public static final String TAG = "searchPath";
    public static final String ATTR_NAME = "name";
    private final String m_name;
    private final ArrayList<Provider> m_providers = new ArrayList();
    private final ResourceMap m_resourceMap;

    public SearchPath(ResourceMap rmap, String name) {
        this.m_resourceMap = rmap;
        this.m_name = name;
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_NAME, (String)this.m_name);
    }

    public void addPrefixMappings(HashMap<String, String> prefixMappings) {
        for (Provider provider : this.m_providers) {
            provider.addPrefixMappings(prefixMappings);
        }
    }

    public final void addProvider(Provider provider) {
        this.m_providers.add(provider);
    }

    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        for (Provider provider : this.m_providers) {
            provider.toSax(handler, namespace, prefix, provider.getDefaultTag());
        }
    }

    public String getDefaultTag() {
        return TAG;
    }

    public final String getName() {
        return this.m_name;
    }

    public ProviderMatch getProvider(NodeQuery query, List<Provider> noGoodList, MultiStatus problemCollector, IProgressMonitor monitor) throws CoreException {
        int provCnt = this.m_providers.size();
        if (provCnt == 0) {
            throw new CoreException((IStatus)problemCollector);
        }
        monitor.beginTask("Matching providers", provCnt * 1000);
        try {
            ProviderMatch bestMatch = null;
            IVersionDesignator desiredVersion = query.getVersionDesignator();
            for (Provider provider : this.m_providers) {
                if (noGoodList.contains(provider)) continue;
                query.logDecision(ResolverDecisionType.TRYING_PROVIDER, new Object[]{provider.getReaderTypeId(), provider.getURI()});
                ProviderMatch match = provider.findMatch(query, problemCollector, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
                if (match == null) {
                    noGoodList.add(provider);
                    continue;
                }
                String readerType = provider.getReaderTypeId();
                ProviderScore score = match.getProviderScore();
                if (score.ordinal() >= ProviderScore.FAIR.ordinal() && "local".equals(readerType) || score.ordinal() >= ProviderScore.GOOD.ordinal() && desiredVersion != null && desiredVersion.isIdeal(match.getVersionMatch().getVersion())) {
                    bestMatch = match;
                    break;
                }
                if (bestMatch == null || match.compareTo(bestMatch) > 0) {
                    if (bestMatch != null) {
                        Provider rejected = bestMatch.getOriginalProvider();
                        query.logDecision(ResolverDecisionType.REJECTING_PROVIDER, new Object[]{rejected.getReaderTypeId(), rejected.getURI(), NLS.bind((String)Messages._0_1_is_producing_a_better_match, (Object)provider.getReaderTypeId(), (Object)((Object)provider.getURI()))});
                    }
                    bestMatch = match;
                    continue;
                }
                Provider best = bestMatch.getOriginalProvider();
                query.logDecision(ResolverDecisionType.REJECTING_PROVIDER, new Object[]{provider.getReaderTypeId(), provider.getURI(), NLS.bind((String)Messages._0_1_is_producing_a_better_match, (Object)best.getReaderTypeId(), (Object)((Object)best.getURI()))});
            }
            if (bestMatch == null) {
                query.logDecision(ResolverDecisionType.PROVIDER_NOT_FOUND, new Object[0]);
                throw new CoreException((IStatus)problemCollector);
            }
            Provider best = bestMatch.getOriginalProvider();
            query.logDecision(ResolverDecisionType.USING_PROVIDER, new Object[]{best.getReaderTypeId(), best.getURI()});
            ProviderMatch providerMatch = bestMatch;
            return providerMatch;
        }
        finally {
            monitor.done();
        }
    }

    public List<Provider> getProviders() {
        return this.m_providers;
    }

    public ResourceMap getResourceMap() {
        return this.m_resourceMap;
    }
}

