/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.rmap.model;

import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.rmap.model.BidirectionalTransformer;
import org.eclipse.buckminster.core.version.AbstractConverter;
import org.eclipse.buckminster.core.version.IVersionConverter;
import org.eclipse.buckminster.core.version.IVersionType;
import org.eclipse.buckminster.sax.AbstractSaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class VersionConverterDesc
extends AbstractSaxableElement {
    public static final String TAG = "versionConverter";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_VERSION_TYPE = "versionType";
    private final String m_type;
    private final BidirectionalTransformer[] m_transformers;
    private final IVersionType m_versionType;

    public VersionConverterDesc(String type, IVersionType versionType, BidirectionalTransformer[] transformers) {
        this.m_type = type;
        this.m_transformers = transformers;
        this.m_versionType = versionType;
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_TYPE, (String)this.m_type);
        if (this.m_versionType != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_VERSION_TYPE, (String)this.m_versionType.getId());
        }
    }

    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        BidirectionalTransformer[] bidirectionalTransformerArray = this.m_transformers;
        int n = this.m_transformers.length;
        int n2 = 0;
        while (n2 < n) {
            BidirectionalTransformer transformer = bidirectionalTransformerArray[n2];
            transformer.toSax(handler, namespace, prefix, transformer.getDefaultTag());
            ++n2;
        }
    }

    public String getDefaultTag() {
        return TAG;
    }

    public final BidirectionalTransformer[] getTransformers() {
        return this.m_transformers;
    }

    public final String getType() {
        return this.m_type;
    }

    public IVersionConverter getVersionConverter() throws CoreException {
        AbstractConverter vct = (AbstractConverter)CorePlugin.getDefault().getVersionConverter(this.m_type);
        vct.setTransformers(this.m_transformers);
        vct.setVersionType(this.m_versionType);
        return vct;
    }
}

