/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.rmap.parser;

import org.eclipse.buckminster.core.parser.ExtensionAwareHandler;
import org.eclipse.buckminster.core.rmap.model.Locator;
import org.eclipse.buckminster.core.rmap.model.Redirect;
import org.eclipse.buckminster.core.rmap.model.ResourceMap;
import org.eclipse.buckminster.core.rmap.parser.ResourceMapHandler;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

abstract class MatcherHandler
extends ExtensionAwareHandler {
    private String m_pattern;

    public MatcherHandler(AbstractHandler parent) {
        super(parent);
    }

    final String getPattern() {
        return this.m_pattern;
    }

    final ResourceMap getResourceMap() {
        return ((ResourceMapHandler)this.getParentHandler()).getResourceMap();
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        this.m_pattern = this.getStringValue(attrs, "pattern");
    }

    static class LocatorHandler
    extends MatcherHandler {
        static final String TAG = "locator";

        public LocatorHandler(AbstractHandler parent) {
            super(parent);
        }

        public void handleAttributes(Attributes attrs) throws SAXException {
            super.handleAttributes(attrs);
            ResourceMap rmap = this.getResourceMap();
            rmap.addMatcher(new Locator(rmap, this.getPattern(), this.getStringValue(attrs, "searchPathRef")));
        }
    }

    static class RedirectHandler
    extends MatcherHandler {
        static final String TAG = "redirect";

        public RedirectHandler(AbstractHandler parent) {
            super(parent);
        }

        public void handleAttributes(Attributes attrs) throws SAXException {
            super.handleAttributes(attrs);
            ResourceMap rmap = this.getResourceMap();
            String href = this.getStringValue(attrs, "href");
            rmap.addMatcher(new Redirect(rmap, this.getPattern(), href));
        }
    }
}

