/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.rmap.parser;

import java.util.regex.PatternSyntaxException;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.common.parser.RxAssemblyHandler;
import org.eclipse.buckminster.core.rmap.model.URIMatcher;
import org.eclipse.buckminster.core.rmap.parser.ProviderHandler;
import org.eclipse.buckminster.core.version.IVersionType;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.core.runtime.CoreException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class URIMatcherHandler
extends RxAssemblyHandler {
    public static final String TAG = "matcher";
    private String m_base;
    private IVersionType m_versionType;
    private String m_componentType = "unknown";

    public URIMatcherHandler(AbstractHandler parent) {
        super(parent);
        ProviderHandler parentHandler;
        String[] componentTypes;
        if (parent instanceof ProviderHandler && (componentTypes = (parentHandler = (ProviderHandler)this.getParentHandler()).getComponentTypes()).length == 1) {
            this.m_componentType = componentTypes[0];
        }
    }

    URIMatcher createURIMetaData() throws CoreException, PatternSyntaxException {
        return new URIMatcher(this.getParts(), this.m_base, this.m_versionType, this.m_componentType);
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        super.handleAttributes(attrs);
        this.m_base = this.getStringValue(attrs, "base");
        String tmp = URIMatcherHandler.getOptionalStringValue((Attributes)attrs, (String)"versionType");
        if (tmp == null) {
            this.m_versionType = null;
        } else {
            try {
                this.m_versionType = CorePlugin.getDefault().getVersionType(tmp);
            }
            catch (CoreException e) {
                throw new SAXParseException(e.getMessage(), this.getDocumentLocator(), (Exception)((Object)e));
            }
        }
    }
}

