/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.site;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IStreamConsumer;
import org.eclipse.buckminster.core.site.SaxableSite;
import org.eclipse.buckminster.download.DownloadManager;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteContentProvider;
import org.eclipse.update.core.Site;
import org.eclipse.update.core.model.DefaultSiteParser;
import org.eclipse.update.core.model.SiteModelFactory;
import org.eclipse.update.internal.core.ExtendedSiteURLFactory;
import org.eclipse.update.internal.core.SiteFileContentProvider;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteReader
implements IStreamConsumer<SaxableSite> {
    public static SaxableSite getSite(File siteFile) throws CoreException, IOException {
        SaxableSite saxableSite;
        BufferedInputStream input = null;
        try {
            SaxableSite site;
            input = new BufferedInputStream(new FileInputStream(siteFile));
            saxableSite = site = SiteReader.parseSite(input, siteFile.toURI().toURL());
        }
        catch (Throwable throwable) {
            IOUtils.close(input);
            throw throwable;
        }
        IOUtils.close((Closeable)input);
        return saxableSite;
    }

    public static SaxableSite getSite(URL siteURL, IConnectContext cctx) throws CoreException, IOException {
        InputStream input = null;
        try {
            SaxableSite site;
            input = DownloadManager.read((URL)siteURL, (IConnectContext)cctx);
            SaxableSite saxableSite = site = SiteReader.parseSite(input, siteURL);
            return saxableSite;
        }
        finally {
            IOUtils.close((Closeable)input);
        }
    }

    private static SaxableSite parseSite(InputStream input, URL url) throws CoreException, IOException {
        try {
            SiteFileContentProvider contentProvider = new SiteFileContentProvider(url);
            ExtendedSiteURLFactory factory = new ExtendedSiteURLFactory();
            ExtendedDefaultSiteParser parser = new ExtendedDefaultSiteParser();
            parser.init((SiteModelFactory)factory);
            Site site = (Site)parser.parse(input);
            MultiStatus status = parser.getStatus();
            if (status != null) {
                throw new CoreException((IStatus)status);
            }
            site.setSiteContentProvider((ISiteContentProvider)contentProvider);
            contentProvider.setSite((ISite)site);
            site.resolve(url, url);
            return new SaxableSite(site, parser.getMirrorsURL(), parser.getAssociateSitesURL());
        }
        catch (SAXException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    @Override
    public SaxableSite consumeStream(IComponentReader fileReader, String streamName, InputStream stream, IProgressMonitor monitor) throws CoreException {
        monitor = MonitorUtils.ensureNotNull((IProgressMonitor)monitor);
        monitor.beginTask(null, 1);
        try {
            monitor.subTask(Messages.Loading_site_definition);
            SaxableSite site = SiteReader.parseSite(stream, URLUtils.normalizeToURL((String)streamName));
            MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
            SaxableSite saxableSite = site;
            return saxableSite;
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        finally {
            monitor.done();
        }
    }

    static class ExtendedDefaultSiteParser
    extends DefaultSiteParser {
        private boolean m_atTop = true;
        private String m_mirrorsURL;
        private String m_associateSitesURL;

        ExtendedDefaultSiteParser() {
        }

        String getAssociateSitesURL() {
            return this.m_associateSitesURL;
        }

        String getMirrorsURL() {
            return this.m_mirrorsURL;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if (this.m_atTop) {
                this.m_mirrorsURL = TextUtils.notEmptyTrimmedString(attributes.getValue("mirrorsURL"));
                this.m_associateSitesURL = TextUtils.notEmptyTrimmedString(attributes.getValue("associateSitesURL"));
                this.m_atTop = false;
            }
        }
    }
}

