/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.version;

import org.eclipse.buckminster.core.helpers.AbstractExtension;
import org.eclipse.buckminster.core.rmap.model.BidirectionalTransformer;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.IVersionConverter;
import org.eclipse.buckminster.core.version.IVersionType;
import org.eclipse.core.runtime.CoreException;

public abstract class AbstractConverter
extends AbstractExtension
implements IVersionConverter {
    private static final BidirectionalTransformer[] s_noTransformers = new BidirectionalTransformer[0];
    private BidirectionalTransformer[] m_transformers = s_noTransformers;
    private IVersionType m_versionType = this.getDefaultVersionType();

    protected String createSelectorComponent(IVersion source) throws CoreException {
        String result = source.toString();
        if (this.m_transformers.length > 0) {
            boolean matchFound = false;
            BidirectionalTransformer[] bidirectionalTransformerArray = this.m_transformers;
            int n = this.m_transformers.length;
            int n2 = 0;
            while (n2 < n) {
                BidirectionalTransformer transformer = bidirectionalTransformerArray[n2];
                String transformed = transformer.transformFrom(result);
                if (transformed != null) {
                    matchFound = true;
                    result = transformed;
                }
                ++n2;
            }
            if (!matchFound) {
                return null;
            }
        }
        return result;
    }

    protected IVersion createVersionFromSelectorComponent(String source) throws CoreException {
        if (this.m_transformers.length > 0) {
            boolean matchFound = false;
            BidirectionalTransformer[] bidirectionalTransformerArray = this.m_transformers;
            int n = this.m_transformers.length;
            int n2 = 0;
            while (n2 < n) {
                BidirectionalTransformer transformer = bidirectionalTransformerArray[n2];
                String transformed = transformer.transformTo(source);
                if (transformed != null) {
                    matchFound = true;
                    source = transformed;
                }
                ++n2;
            }
            if (!matchFound) {
                return null;
            }
        }
        return this.m_versionType.fromString(source);
    }

    protected abstract IVersionType getDefaultVersionType();

    public IVersionType getVersionType() {
        return this.m_versionType;
    }

    public final void setTransformers(BidirectionalTransformer[] transformers) {
        this.m_transformers = transformers == null ? s_noTransformers : transformers;
    }

    public final void setVersionType(IVersionType versionType) {
        this.m_versionType = versionType == null ? this.getDefaultVersionType() : versionType;
    }
}

