/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.version;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.version.AbstractVersion;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.IVersionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTripletVersion
extends AbstractVersion {
    private static final Pattern s_numPattern = Pattern.compile("^([A-Za-z_-]*)(\\d+)(.*)$");
    private static final Comparator<String> s_defaultComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            int o2len;
            int o1len;
            Matcher m2;
            if (o1 == null) {
                return o2 == null ? 0 : 1;
            }
            if (o2 == null) {
                return -1;
            }
            Matcher m1 = s_numPattern.matcher(o1);
            if (m1.matches() && (m2 = s_numPattern.matcher(o2)).matches()) {
                int v2;
                int cmp = m1.group(1).compareTo(m2.group(1));
                if (cmp != 0) {
                    return cmp;
                }
                int v1 = Integer.parseInt(m1.group(2));
                if (v1 < (v2 = Integer.parseInt(m2.group(2)))) {
                    return -1;
                }
                if (v1 > v2) {
                    return 1;
                }
                o1 = m1.group(3);
                o2 = m2.group(3);
            }
            if ((o1len = o1.length()) > (o2len = o2.length()) && o1.startsWith(o2)) {
                return -1;
            }
            if (o2len > o1len && o2.startsWith(o1)) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    };
    private final int m_major;
    private final int m_minor;
    private final int m_micro;
    private final String m_qualifier;

    public AbstractTripletVersion(IVersionType type, int major, int minor, int micro, String qualifier) {
        super(type);
        this.m_major = major;
        this.m_minor = minor;
        this.m_micro = micro;
        if (qualifier != null && qualifier.length() == 0) {
            qualifier = null;
        }
        this.m_qualifier = qualifier;
    }

    @Override
    public int compareTo(IVersion o) {
        if (!(o instanceof AbstractTripletVersion)) {
            throw new IllegalArgumentException(Messages.Not_a_Triplet);
        }
        AbstractTripletVersion ov = (AbstractTripletVersion)o;
        if (this.m_major > ov.m_major) {
            return 1;
        }
        if (this.m_major < ov.m_major) {
            return -1;
        }
        if (this.m_minor > ov.m_minor) {
            return 1;
        }
        if (this.m_minor < ov.m_minor) {
            return -1;
        }
        if (this.m_micro > ov.m_micro) {
            return 1;
        }
        if (this.m_micro < ov.m_micro) {
            return -1;
        }
        return this.getQualifierComparator().compare(this.m_qualifier, ov.m_qualifier);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractTripletVersion)) {
            return false;
        }
        AbstractTripletVersion that = (AbstractTripletVersion)o;
        return this.compareTo(that) == 0;
    }

    @Override
    public boolean equalsUnqualified(IVersion version) {
        if (version == this) {
            return true;
        }
        if (!(version instanceof AbstractTripletVersion)) {
            return false;
        }
        AbstractTripletVersion that = (AbstractTripletVersion)version;
        return this.getMajor() == that.getMajor() && this.getMinor() == that.getMinor() && this.getMicro() == that.getMicro();
    }

    public final int getMajor() {
        return this.m_major;
    }

    public final int getMicro() {
        return this.m_micro;
    }

    public final int getMinor() {
        return this.m_minor;
    }

    @Override
    public final String getQualifier() {
        return this.m_qualifier;
    }

    public Comparator<String> getQualifierComparator() {
        return s_defaultComparator;
    }

    public int hashCode() {
        int hc = 17;
        hc = 37 * hc + this.m_major;
        hc = 37 * hc + this.m_minor;
        hc = 37 * hc + this.m_micro;
        hc = 37 * hc + (this.m_qualifier == null ? 0 : this.m_qualifier.hashCode());
        return hc;
    }
}

