/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.version;

import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.reader.IVersionFinder;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolverDecision;
import org.eclipse.buckminster.core.resolver.ResolverDecisionType;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.rmap.model.ProviderScore;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.security.IConnectContext;

public abstract class AbstractVersionFinder
implements IVersionFinder {
    private final Provider m_provider;
    private final NodeQuery m_query;
    private final IComponentType m_componentType;

    public AbstractVersionFinder(Provider provider, IComponentType componentType, NodeQuery query) {
        this.m_provider = provider;
        this.m_query = query;
        this.m_componentType = componentType;
    }

    public void close() {
    }

    public IComponentType getComponentType() {
        return this.m_componentType;
    }

    public IConnectContext getConnectContext() {
        IConnectContext cctx = this.m_provider.getConnectContext();
        if (cctx == null) {
            cctx = this.m_query.getComponentQuery().getConnectContext();
        }
        return cctx;
    }

    public Provider getProvider() {
        return this.m_provider;
    }

    public ProviderMatch getProviderMatch(VersionMatch versionMatch, IComponentType ctypeUsed, ProviderScore score) throws CoreException {
        return new ProviderMatch(this.m_provider, ctypeUsed, versionMatch, score, this.m_query);
    }

    public NodeQuery getQuery() {
        return this.m_query;
    }

    protected IVersion getVersionFromArtifacts(VersionSelector branchOrTag, IProgressMonitor monitor) throws CoreException {
        VersionMatch match = new VersionMatch(null, branchOrTag, this.m_query.getRevision(), this.m_query.getTimestamp(), null);
        ProviderMatch rInfo = new ProviderMatch(this.m_provider, this.m_componentType, match, this.m_query);
        return this.m_componentType.getComponentVersion(rInfo, monitor);
    }

    public ResolverDecision logDecision(ComponentRequest request, ResolverDecisionType decisionType, Object ... args) {
        return this.m_query.logDecision(decisionType, args);
    }

    public ResolverDecision logDecision(ResolverDecisionType decisionType, Object ... args) {
        return this.m_query.logDecision(decisionType, args);
    }
}

