/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.version;

import java.util.Comparator;
import org.eclipse.buckminster.core.version.AbstractTripletVersion;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.IVersionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiVersion
extends AbstractTripletVersion {
    private static final Comparator<String> s_defaultComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1.equals(o2)) {
                return 0;
            }
            if (o1.equals("qualifier")) {
                return 1;
            }
            if (o2.equals("qualifier")) {
                return -1;
            }
            return o1.compareTo(o2);
        }
    };

    public OSGiVersion(IVersionType type, int major, int minor, int micro, String qualifier) {
        super(type, major, minor, micro, qualifier);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OSGiVersion)) {
            return false;
        }
        OSGiVersion that = (OSGiVersion)o;
        return this.compareTo(that) == 0;
    }

    @Override
    public Comparator<String> getQualifierComparator() {
        return s_defaultComparator;
    }

    @Override
    public IVersion replaceQualifier(String qualifier) {
        return new OSGiVersion(this.getType(), this.getMajor(), this.getMinor(), this.getMicro(), qualifier);
    }

    @Override
    public void toString(StringBuilder bld) {
        bld.append(this.getMajor());
        bld.append('.');
        bld.append(this.getMinor());
        bld.append('.');
        bld.append(this.getMicro());
        if (this.getQualifier() != null) {
            bld.append('.');
            bld.append(this.getQualifier());
        }
    }
}

