/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.version;

import org.eclipse.buckminster.core.internal.version.TripletVersionType;
import org.eclipse.buckminster.core.version.AbstractTripletVersion;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.IVersionType;

public class TripletVersion
extends AbstractTripletVersion {
    private final String m_stringForm;

    public TripletVersion(IVersionType type, int major, int minor, int micro, String qualifier, String stringForm) {
        super(type, major, minor, micro, qualifier);
        this.m_stringForm = stringForm;
    }

    public boolean hasMicro() {
        return TripletVersionType.hasMicro(this.m_stringForm);
    }

    public boolean hasMinor() {
        return TripletVersionType.hasMinor(this.m_stringForm);
    }

    public IVersion replaceQualifier(String qualifier) {
        String stringForm = this.m_stringForm;
        String qual = this.getQualifier();
        stringForm = qual != null ? (qualifier != null ? String.valueOf(stringForm.substring(0, stringForm.length() - qual.length())) + qualifier : stringForm.substring(0, stringForm.length() - (qual.length() + 1))) : String.valueOf(stringForm) + '-' + qualifier;
        return new TripletVersion(this.getType(), this.getMajor(), this.getMinor(), this.getMicro(), qualifier, stringForm);
    }

    public String toString() {
        return this.m_stringForm;
    }

    public void toString(StringBuilder bld) {
        bld.append(this.m_stringForm);
    }
}

