/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.version;

import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.internal.version.VersionDesignator;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.IVersionDesignator;
import org.eclipse.buckminster.core.version.IVersionType;
import org.eclipse.buckminster.core.version.VersionSyntaxException;
import org.eclipse.core.runtime.CoreException;

public class VersionFactory {
    public static final IVersionType StringType;
    public static final IVersionType OSGiType;
    public static final IVersionType TripletType;
    public static final IVersionType TimestampType;

    static {
        try {
            OSGiType = CorePlugin.getDefault().getVersionType("OSGi");
            TimestampType = CorePlugin.getDefault().getVersionType("Timestamp");
            StringType = CorePlugin.getDefault().getVersionType("String");
            TripletType = CorePlugin.getDefault().getVersionType("Triplet");
        }
        catch (CoreException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static IVersionDesignator createDesignator(IVersionType versionType, String versionString) throws VersionSyntaxException {
        return VersionDesignator.fromString(versionType, versionString);
    }

    public static IVersionDesignator createDesignator(String versionType, String versionString) throws CoreException {
        return VersionFactory.createDesignator(CorePlugin.getDefault().getVersionType(versionType), versionString);
    }

    public static IVersionDesignator createExplicitDesignator(IVersion version) {
        return VersionDesignator.explicit(version);
    }

    public static IVersionDesignator createExplicitDesignator(IVersionType versionType, String versionString) throws VersionSyntaxException {
        return VersionDesignator.explicitFromString(versionType, versionString);
    }

    public static IVersionDesignator createExplicitDesignator(String versionType, String versionString) throws CoreException {
        return VersionFactory.createExplicitDesignator(CorePlugin.getDefault().getVersionType(versionType), versionString);
    }

    public static IVersionDesignator createGTEqualDesignator(IVersion version) {
        return VersionDesignator.GTEqual(version);
    }

    public static IVersionDesignator createRangeDesignator(IVersion low, boolean includeLow, IVersion high, boolean includeHigh) {
        return VersionDesignator.create(low, includeLow, high, includeHigh);
    }

    public static IVersion createVersion(String versionType, String versionString) throws CoreException {
        IVersionType vt = CorePlugin.getDefault().getVersionType(versionType);
        return vt.fromString(versionString);
    }
}

