/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.cvspkg.internal;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.reader.CatalogReaderType;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.reader.IVersionFinder;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.cvspkg.Messages;
import org.eclipse.buckminster.cvspkg.internal.CVSReader;
import org.eclipse.buckminster.cvspkg.internal.CVSSession;
import org.eclipse.buckminster.cvspkg.internal.RepositoryMetaData;
import org.eclipse.buckminster.cvspkg.internal.VersionFinder;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CVSReaderType
extends CatalogReaderType {
    public static final String LOCAL_LINE_END = System.getProperty("line.separator");
    public static final Command.LocalOption STDOUT = new MyLocalOption("-p");

    public static CVSRepositoryLocation getLocationFromString(String repo) throws CVSException {
        CVSRepositoryLocation wanted = CVSRepositoryLocation.fromString((String)repo);
        String wantedUser = wanted.getUsername();
        ICVSRepositoryLocation[] iCVSRepositoryLocationArray = CVSProviderPlugin.getPlugin().getKnownRepositories();
        int n = iCVSRepositoryLocationArray.length;
        int n2 = 0;
        while (n2 < n) {
            String wantedMethod;
            String knownMethod;
            ICVSRepositoryLocation known = iCVSRepositoryLocationArray[n2];
            if (known.getHost().equals(wanted.getHost()) && known.getPort() == wanted.getPort() && known.getRootDirectory().equals(wanted.getRootDirectory()) && ((knownMethod = known.getMethod().getName()).equals(wantedMethod = wanted.getMethod().getName()) || "extssh".equals(knownMethod) && "pserver".equals(wantedMethod)) && (wantedUser == null || "anonymous".equals(wantedUser) || wantedUser.equals(known.getUsername()))) {
                return (CVSRepositoryLocation)known;
            }
            ++n2;
        }
        KnownRepositories.getInstance().addRepository((ICVSRepositoryLocation)wanted, true);
        return wanted;
    }

    static CVSTag getCVSTag(VersionMatch match) throws CoreException {
        Date timestamp;
        VersionSelector selector = match.getBranchOrTag();
        CVSTag tag = selector == null && (timestamp = match.getTimestamp()) != null ? new CVSTag(timestamp) : CVSReaderType.getCVSTag(selector);
        return tag;
    }

    static CVSTag getCVSTag(VersionSelector selector) throws CoreException {
        CVSTag tag = selector == null ? CVSTag.DEFAULT : new CVSTag(selector.getName(), selector.getType() == 1 ? 2 : 1);
        return tag;
    }

    public String convertFetchFactoryLocator(Map<String, String> fetchFactoryLocator, String componentName) throws CoreException {
        String cvsRoot = fetchFactoryLocator.get("cvsRoot");
        if (cvsRoot == null) {
            throw BuckminsterException.fromMessage((String)Messages.illegal_fetch_factory_locator, (Object[])new Object[0]);
        }
        StringBuilder locator = new StringBuilder(cvsRoot);
        String path = fetchFactoryLocator.get("path");
        locator.append(',');
        if (path != null) {
            locator.append(path);
        } else {
            locator.append(componentName);
        }
        return locator.toString();
    }

    public URL convertToURL(String repositoryLocator, VersionMatch versionMatch) throws CoreException {
        try {
            String user;
            VersionSelector versionSelector = versionMatch.getBranchOrTag();
            CVSSession session = new CVSSession(repositoryLocator);
            ICVSRepositoryLocation location = session.getLocation();
            StringBuilder query = new StringBuilder();
            String method = location.getMethod().getName();
            if (!method.equals("pserver")) {
                query.append("method=");
                query.append(method);
            }
            if (versionSelector != null) {
                if (query.length() > 0) {
                    query.append('&');
                }
                query.append("version");
                query.append(versionSelector.toString());
            }
            if ("anonymous".equals(user = location.getUsername())) {
                user = null;
            }
            IPath modulePath = new Path(session.getModuleName()).makeAbsolute();
            URI uri = new URI("cvs", user, location.getHost(), -1, location.getRootDirectory(), query.toString(), modulePath.toPortableString());
            return uri.toURL();
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    public URI getArtifactURL(Resolution resolution, RMContext context) throws CoreException {
        return null;
    }

    public Date getLastModification(File workingCopy, IProgressMonitor monitor) throws CoreException {
        Date youngest;
        block14: {
            monitor.beginTask(null, 30);
            File[] folders = workingCopy.listFiles();
            MonitorUtils.worked((IProgressMonitor)monitor, (int)10);
            if (folders == null) {
                monitor.done();
                return null;
            }
            youngest = null;
            if (folders.length > 0) {
                IProgressMonitor subMon = MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10);
                subMon.beginTask(null, folders.length * 10);
                File[] fileArray = folders;
                int n = folders.length;
                int n2 = 0;
                while (n2 < n) {
                    File subFolder = fileArray[n2];
                    Date ts = this.getLastModification(subFolder, MonitorUtils.subMonitor((IProgressMonitor)subMon, (int)10));
                    if (ts != null && (youngest == null || ts.compareTo(youngest) > 0)) {
                        youngest = ts;
                    }
                    ++n2;
                }
                subMon.done();
            } else {
                MonitorUtils.worked((IProgressMonitor)monitor, (int)10);
            }
            File entries = new File(new File(workingCopy, "CVS"), "Entries");
            BufferedReader input = null;
            try {
                String line;
                input = new BufferedReader(new FileReader(entries));
                while ((line = input.readLine()) != null) {
                    try {
                        ResourceSyncInfo info = new ResourceSyncInfo(line, null);
                        Date ts = info.getTimeStamp();
                        if (ts == null || youngest != null && ts.compareTo(youngest) <= 0) continue;
                        youngest = ts;
                    }
                    catch (CVSException cVSException) {
                        // empty catch block
                    }
                }
                MonitorUtils.worked((IProgressMonitor)monitor, (int)10);
            }
            catch (FileNotFoundException line) {
                IOUtils.close(input);
                monitor.done();
                break block14;
            }
            catch (IOException e) {
                try {
                    throw BuckminsterException.wrap((Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.close(input);
                    monitor.done();
                    throw throwable;
                }
            }
            IOUtils.close((Closeable)input);
            monitor.done();
        }
        return youngest;
    }

    public Date getLastModification(String repositoryLocation, VersionSelector versionSelector, IProgressMonitor monitor) throws CoreException {
        CVSSession session = null;
        try {
            session = new CVSSession(repositoryLocation);
            RepositoryMetaData metaData = RepositoryMetaData.getMetaData(session, CVSReaderType.getCVSTag(versionSelector), monitor);
            Date date = metaData.getLastModification();
            return date;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public IComponentReader getReader(ProviderMatch providerMatch, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.complete((IProgressMonitor)monitor);
        return new CVSReader((IReaderType)this, providerMatch);
    }

    public String getRemoteLocation(File workingCopy, IProgressMonitor monitor) throws CoreException {
        IPath location;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IContainer resource = wsRoot.getContainerForLocation(location = Path.fromOSString((String)workingCopy.toString()));
        if (resource == null) {
            resource = wsRoot.getFileForLocation(location);
        }
        if (resource == null) {
            return null;
        }
        ICVSRemoteResource cvsResource = CVSWorkspaceRoot.getRemoteResourceFor((IResource)resource);
        if (cvsResource == null) {
            return null;
        }
        return String.valueOf(cvsResource.getRepository().getLocation(false)) + ',' + cvsResource.getRepositoryRelativePath();
    }

    public IVersionFinder getVersionFinder(Provider provider, IComponentType ctype, NodeQuery nodeQuery, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.complete((IProgressMonitor)monitor);
        return new VersionFinder(provider, ctype, nodeQuery);
    }

    public void shareProject(IProject project, Resolution cr, RMContext context, IProgressMonitor monitor) throws CoreException {
        String cvsTypeID = CVSProviderPlugin.getTypeId();
        RepositoryProvider.map((IProject)project, (String)cvsTypeID);
        ((CVSTeamProvider)RepositoryProvider.getProvider((IProject)project, (String)cvsTypeID)).setWatchEditEnabled(CVSProviderPlugin.getPlugin().isWatchEditEnabled());
    }

    static class MyLocalOption
    extends Command.LocalOption {
        MyLocalOption(String opt) {
            super(opt);
        }
    }
}

