/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.cvspkg.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.eclipse.buckminster.cvspkg.CVSPlugin;
import org.eclipse.buckminster.cvspkg.Messages;
import org.eclipse.buckminster.cvspkg.internal.CVSReader;
import org.eclipse.buckminster.cvspkg.internal.CVSSession;
import org.eclipse.buckminster.cvspkg.internal.MetaDataCollector;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.RLog;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryMetaData
implements Serializable {
    private static final long serialVersionUID = 6869163410872011769L;
    private static final HashMap<UUID, RepositoryMetaData> s_metaDataCache = new HashMap();
    private final String[] m_branchNames;
    private final String[] m_tagNames;
    private final Date m_lastModification;
    private final Date m_timestamp;

    public static RepositoryMetaData getMetaData(CVSSession cvsSession, CVSTag fixedTag, IProgressMonitor monitor) throws CoreException {
        String repository = cvsSession.getRepository();
        RepositoryMetaData result = RepositoryMetaData.load(fixedTag, repository);
        Date now = new Date(System.currentTimeMillis());
        if (result != null) {
            Date resultTime = result.getTimestamp();
            if (fixedTag != null && fixedTag.getType() == 3 && CVSReader.getTagDate(fixedTag).compareTo(resultTime) <= 0) {
                return result;
            }
            if (now.getTime() - resultTime.getTime() < 300000L) {
                return result;
            }
        }
        monitor.beginTask(null, 100);
        monitor.subTask(NLS.bind((String)Messages.obtaining_meta_data_for_repository_0, (Object)repository));
        Session session = cvsSession.getReaderSession(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10));
        try {
            Logger logger = CVSPlugin.getLogger();
            ArrayList<Command.LocalOption> opts = new ArrayList<Command.LocalOption>();
            if (result == null) {
                logger.debug("Initial metadata fetch for %s", new Object[]{repository});
                if (fixedTag != null && !fixedTag.equals((Object)CVSTag.DEFAULT)) {
                    opts.add(RLog.getCurrentTag((CVSTag)fixedTag));
                }
            } else {
                if (fixedTag != null) {
                    switch (fixedTag.getType()) {
                        case 3: {
                            now = fixedTag.asDate();
                            if (fixedTag.asDate().compareTo(result.getTimestamp()) <= 0) {
                                RepositoryMetaData repositoryMetaData = result;
                                return repositoryMetaData;
                            }
                            fixedTag = null;
                            break;
                        }
                        case 1: 
                        case 2: {
                            opts.add(RLog.getCurrentTag((CVSTag)fixedTag));
                        }
                    }
                }
                logger.debug("Metadata refetch from " + result.getTimestamp() + " for " + repository, new Object[0]);
                opts.add(RLog.makeTagOption((CVSTag)new CVSTag(result.getTimestamp()), (CVSTag)new CVSTag(now)));
                opts.add(RLog.ONLY_INCLUDE_CHANGES);
            }
            String[] args = new String[]{cvsSession.getModuleName()};
            MetaDataCollector collector = new MetaDataCollector();
            IStatus status = new RLog().execute(session, Command.NO_GLOBAL_OPTIONS, opts.toArray(new Command.LocalOption[opts.size()]), args, (ICommandOutputListener)collector, (IProgressMonitor)new SubProgressMonitor(monitor, 90, 2));
            if (!status.isOK()) {
                throw new CVSException(status);
            }
            if (result == null) {
                if (collector.getLastModificationTime() == null) {
                    throw new CVSException(NLS.bind((String)Messages.found_no_metadata_for_0, (Object)repository));
                }
                result = new RepositoryMetaData(collector, now);
            } else {
                result = result.merge(collector, now);
            }
            result.store(fixedTag, repository);
            RepositoryMetaData repositoryMetaData = result;
            return repositoryMetaData;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RepositoryMetaData load(CVSTag fixedTag, String repository) throws CoreException {
        UUID id = RepositoryMetaData.getRepositoryId(fixedTag, repository);
        RepositoryMetaData rmd = s_metaDataCache.get(id);
        if (rmd != null) {
            return rmd;
        }
        ObjectInputStream input = null;
        try {
            input = new ObjectInputStream(new FileInputStream(RepositoryMetaData.getStateFile(id)));
            rmd = (RepositoryMetaData)input.readObject();
            s_metaDataCache.put(id, rmd);
            RepositoryMetaData repositoryMetaData = rmd;
            IOUtils.close((Closeable)input);
            return repositoryMetaData;
        }
        catch (FileNotFoundException e) {
            return null;
            catch (InvalidClassException e2) {
                return null;
                catch (ClassNotFoundException e3) {
                    throw BuckminsterException.wrap((Throwable)e3);
                }
                catch (IOException e4) {
                    throw BuckminsterException.wrap((Throwable)e4);
                }
            }
        }
        finally {
            IOUtils.close(input);
        }
    }

    private static Set<String> concat(String[] names, Set<String> moreNames) {
        HashSet<String> result = new HashSet<String>(names.length + moreNames.size());
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            result.add(name);
            ++n2;
        }
        result.addAll(moreNames);
        return result;
    }

    private static UUID getRepositoryId(CVSTag fixedTag, String repository) {
        if (fixedTag != null && fixedTag.getType() != 3) {
            repository = String.valueOf(repository) + '#' + fixedTag;
        }
        return UUID.nameUUIDFromBytes(repository.getBytes());
    }

    private static File getStateFile(UUID id) {
        return CVSPlugin.getDefault().getStateLocation().append(id.toString()).toFile();
    }

    private static String[] orderedArray(Set<String> names) {
        Object[] ordered = names.toArray(new String[names.size()]);
        Arrays.sort(ordered);
        return ordered;
    }

    public RepositoryMetaData(MetaDataCollector collector, Date timestamp) {
        this(collector.getBranchNames(), collector.getTagNames(), collector.getLastModificationTime(), timestamp);
    }

    private RepositoryMetaData(Set<String> branches, Set<String> tags, Date lastModification, Date timestamp) {
        this.m_branchNames = RepositoryMetaData.orderedArray(branches);
        this.m_tagNames = RepositoryMetaData.orderedArray(tags);
        this.m_lastModification = lastModification;
        this.m_timestamp = timestamp;
    }

    public final String[] getBranchNames() {
        return this.m_branchNames;
    }

    public final Date getLastModification() {
        return this.m_lastModification;
    }

    public final String[] getTagNames() {
        return this.m_tagNames;
    }

    public final Date getTimestamp() {
        return this.m_timestamp;
    }

    public RepositoryMetaData merge(MetaDataCollector collector, Date timestamp) {
        Date lastModTime = collector.getLastModificationTime();
        if (lastModTime == null) {
            lastModTime = this.m_lastModification;
        }
        return new RepositoryMetaData(RepositoryMetaData.concat(this.m_branchNames, collector.getBranchNames()), RepositoryMetaData.concat(this.m_tagNames, collector.getTagNames()), lastModTime, timestamp);
    }

    public void store(CVSTag fixedTag, String repository) throws CoreException {
        UUID id = RepositoryMetaData.getRepositoryId(fixedTag, repository);
        ObjectOutputStream output = null;
        try {
            try {
                output = new ObjectOutputStream(new FileOutputStream(RepositoryMetaData.getStateFile(id)));
                output.writeObject(this);
                s_metaDataCache.put(id, this);
            }
            catch (IOException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(output);
            throw throwable;
        }
        IOUtils.close((Closeable)output);
    }
}

