/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.download.internal;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.util.Date;
import org.eclipse.buckminster.download.Messages;
import org.eclipse.buckminster.download.internal.Activator;
import org.eclipse.buckminster.download.internal.ProgressStatistics;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.BuckminsterPreferences;
import org.eclipse.buckminster.runtime.FileInfoBuilder;
import org.eclipse.buckminster.runtime.IFileInfo;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.filetransfer.FileTransferJob;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IIncomingFileTransfer;
import org.eclipse.ecf.filetransfer.IRetrieveFileTransferContainerAdapter;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.UserCancelledException;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDataEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDoneEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveStartEvent;
import org.eclipse.ecf.filetransfer.identity.FileIDFactory;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.osgi.util.NLS;

public class FileReader
extends FileTransferJob
implements IFileTransferListener {
    private boolean m_closeStreamWhenFinished = false;
    private Exception m_exception;
    private IFileInfo m_fileInfo;
    private long m_lastProgressCount;
    private long m_lastStatsCount;
    private IProgressMonitor m_monitor;
    private boolean m_onlyGetInfo = false;
    private OutputStream m_outputStream;
    private ProgressStatistics m_statistics;
    private final int m_connectionRetryCount;
    private final long m_connectionRetryDelay;
    private final IConnectContext m_connectContext;

    public FileReader(IConnectContext connectContext) {
        super(Messages.URL_reader);
        this.setSystem(true);
        this.setUser(false);
        this.m_connectionRetryCount = BuckminsterPreferences.getConnectionRetryCount();
        this.m_connectionRetryDelay = (long)BuckminsterPreferences.getConnectionRetryDelay() * 1000L;
        this.m_connectContext = connectContext;
    }

    public IFileInfo getLastFileInfo() {
        return this.m_fileInfo;
    }

    public synchronized void handleTransferEvent(IFileTransferEvent event) {
        if (event instanceof IIncomingFileTransferReceiveStartEvent) {
            IIncomingFileTransfer source = ((IIncomingFileTransferEvent)event).getSource();
            try {
                FileInfoBuilder fi = new FileInfoBuilder();
                Date lastModified = source.getRemoteLastModified();
                if (lastModified != null) {
                    fi.setLastModified(lastModified.getTime());
                }
                fi.setName(source.getRemoteFileName());
                fi.setSize(source.getFileLength());
                this.m_fileInfo = fi;
                if (this.m_onlyGetInfo) {
                    source.cancel();
                } else {
                    ((IIncomingFileTransferReceiveStartEvent)event).receive(this.m_outputStream, (FileTransferJob)this);
                }
            }
            catch (IOException e) {
                this.m_exception = e;
                return;
            }
            if (this.m_monitor != null) {
                long fileLength = source.getFileLength();
                this.m_statistics = new ProgressStatistics(source.getRemoteFileName(), fileLength);
                this.m_monitor.beginTask(null, 1000);
                this.m_monitor.subTask(this.m_statistics.report());
                this.m_lastStatsCount = 0L;
                this.m_lastProgressCount = 0L;
            }
        } else if (event instanceof IIncomingFileTransferReceiveDataEvent) {
            IIncomingFileTransfer source = ((IIncomingFileTransferEvent)event).getSource();
            if (this.m_monitor != null) {
                if (this.m_monitor.isCanceled()) {
                    source.cancel();
                    return;
                }
                long br = source.getBytesReceived();
                long count = br - this.m_lastStatsCount;
                this.m_lastStatsCount = br;
                this.m_statistics.increase(count);
                if (this.m_statistics.shouldReport()) {
                    count = br - this.m_lastProgressCount;
                    this.m_lastProgressCount = br;
                    this.m_monitor.subTask(this.m_statistics.report());
                    this.m_monitor.worked((int)(1000L * count / this.m_statistics.getTotal()));
                }
            }
        } else if (event instanceof IIncomingFileTransferReceiveDoneEvent) {
            if (this.m_closeStreamWhenFinished) {
                IOUtils.close((Closeable)this.m_outputStream);
            }
            if (this.m_exception == null) {
                this.m_exception = ((IIncomingFileTransferReceiveDoneEvent)event).getException();
                if (this.m_exception instanceof UserCancelledException) {
                    this.m_exception = null;
                }
            }
        }
    }

    public InputStream read(URL url) throws CoreException, FileNotFoundException {
        PipedOutputStream output;
        final PipedInputStream input = new PipedInputStream();
        try {
            output = new PipedOutputStream(input);
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        Buckminster.getLogger().debug("Downloading %s", new Object[]{url});
        NullProgressMonitor cancellationMonitor = new NullProgressMonitor();
        this.sendRetrieveRequest(url, output, true, false, (IProgressMonitor)cancellationMonitor);
        return new InputStream((IProgressMonitor)cancellationMonitor){
            private final /* synthetic */ IProgressMonitor val$cancellationMonitor;
            {
                this.val$cancellationMonitor = iProgressMonitor;
            }

            public int available() throws IOException {
                this.checkException();
                return input.available();
            }

            public void close() throws IOException {
                this.val$cancellationMonitor.setCanceled(true);
                IOUtils.close((Closeable)input);
                this.checkException();
            }

            public void mark(int readlimit) {
                input.mark(readlimit);
            }

            public boolean markSupported() {
                return input.markSupported();
            }

            public int read() throws IOException {
                this.checkException();
                return input.read();
            }

            public int read(byte[] b) throws IOException {
                this.checkException();
                return input.read(b);
            }

            public int read(byte[] b, int off, int len) throws IOException {
                this.checkException();
                return input.read(b, off, len);
            }

            public void reset() throws IOException {
                this.checkException();
                input.reset();
            }

            public long skip(long n) throws IOException {
                this.checkException();
                return input.skip(n);
            }

            private void checkException() throws IOException {
                IOException e;
                if (FileReader.this.m_exception == null) {
                    return;
                }
                Throwable t = BuckminsterException.unwind((Throwable)FileReader.this.m_exception);
                if (t instanceof IOException) {
                    e = (IOException)t;
                } else {
                    e = new IOException(t.getMessage());
                    e.initCause(t);
                }
                throw e;
            }
        };
    }

    public IFileInfo readInfo(URL url) throws CoreException, FileNotFoundException {
        this.sendRetrieveRequest(url, null, false, true, null);
        return this.getLastFileInfo();
    }

    public void readInto(URL url, OutputStream outputStream, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            try {
                this.sendRetrieveRequest(url, outputStream, false, false, monitor);
                this.join();
            }
            catch (InterruptedException e) {
                monitor.setCanceled(true);
                throw new OperationCanceledException();
            }
        }
        finally {
            if (monitor != null) {
                if (this.m_statistics == null) {
                    monitor.beginTask(null, 1);
                } else {
                    this.m_statistics = null;
                }
                monitor.done();
            }
        }
    }

    protected void sendRetrieveRequest(URL url, OutputStream outputStream, boolean closeStreamWhenFinished, boolean onlyGetInfo, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        block9: {
            IRetrieveFileTransferContainerAdapter adapter = Activator.getDefault().createRetrieveFileTransfer();
            adapter.setConnectContextForAuthentication(this.m_connectContext);
            this.m_exception = null;
            this.m_closeStreamWhenFinished = closeStreamWhenFinished;
            this.m_onlyGetInfo = onlyGetInfo;
            this.m_fileInfo = null;
            this.m_statistics = null;
            this.m_lastProgressCount = 0L;
            this.m_lastStatsCount = 0L;
            this.m_monitor = monitor;
            this.m_outputStream = outputStream;
            int retryCount = 0;
            while (true) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    IFileID fileID = FileIDFactory.getDefault().createFileID(adapter.getRetrieveNamespace(), url);
                    adapter.sendRetrieveRequest(fileID, (IFileTransferListener)this, null);
                }
                catch (IncomingFileTransferException e) {
                    this.m_exception = e;
                }
                if (this.m_exception == null) break block9;
                Throwable t = BuckminsterException.unwind((Throwable)this.m_exception);
                while (t instanceof CoreException) {
                    Throwable t2 = ((CoreException)t).getStatus().getException();
                    if (t2 == null) {
                        throw (CoreException)t;
                    }
                    t = t2;
                }
                if (t instanceof FileNotFoundException) {
                    throw (FileNotFoundException)t;
                }
                if (!(t instanceof IOException) || retryCount >= this.m_connectionRetryCount) break;
                ++retryCount;
                this.m_exception = null;
                try {
                    Buckminster.getLogger().warning(NLS.bind((String)Messages.connection_to_0_failed_on_1_retry_attempt_2, (Object[])new String[]{url.toString(), t.getMessage(), String.valueOf(retryCount)}), new Object[0]);
                    Thread.sleep(this.m_connectionRetryDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
            throw BuckminsterException.wrap((Throwable)this.m_exception);
        }
    }
}

