/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.executor.actor;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.actor.AbstractActor;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.helpers.PropertyExpander;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.executor.Messages;
import org.eclipse.buckminster.executor.actor.ShellCommand;
import org.eclipse.buckminster.executor.actor.StreamGobblerRedirector;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutorActor
extends AbstractActor {
    private static final String EXECUTOR_ENV = "env";
    private static final String EXECUTOR_EXEC_ACTION = "exec";
    private static final String EXECUTOR_EXEC_DIR_ACTION = "execDir";
    private static final String EXECUTOR_SHELL_ACTION = "shell";
    private static final String EXECUTOR_NEW_ENVIRONMENT_ACTION = "newenvironment";
    private static final String EXECUTOR_FAIL_ON_ERROR = "failonerror";
    private static final String[] validProperties = new String[]{"env", "exec", "execDir", "shell", "newenvironment", "failonerror"};
    private static final String PLUGIN_ID = "org.eclipse.buckminster.executor";

    private static List<Integer> indexesOf(String string, char c) {
        int index;
        ArrayList<Integer> list = new ArrayList<Integer>();
        int fromIndex = 0;
        while ((index = string.indexOf(c, fromIndex)) != -1) {
            list.add(index);
            fromIndex = index + 1;
        }
        return list;
    }

    static String[] splitEnvironnementVariables(String env) {
        List<Integer> semicolonIndexes = ExecutorActor.indexesOf(env, ';');
        List<Integer> quoteIndexes = ExecutorActor.indexesOf(env, '\"');
        if (quoteIndexes.size() % 2 != 0) {
            throw new IllegalStateException(NLS.bind((String)Messages.odd_number_of_quoting_chars_in_0, (Object)env));
        }
        Iterator<Integer> quoteItr = quoteIndexes.iterator();
        while (quoteItr.hasNext()) {
            int min = quoteItr.next();
            int max = quoteItr.next();
            Iterator<Integer> semicolonItr = semicolonIndexes.iterator();
            while (semicolonItr.hasNext()) {
                int i = semicolonItr.next();
                if (i <= min || i >= max) continue;
                semicolonItr.remove();
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        int lastIndex = 0;
        for (int i : semicolonIndexes) {
            result.add(env.substring(lastIndex, i));
            lastIndex = i + 1;
        }
        result.add(env.substring(lastIndex));
        return result.toArray(new String[result.size()]);
    }

    private void checkProperties() throws CoreException {
        HashSet<String> validSet = new HashSet<String>(Arrays.asList(validProperties));
        Map actorProperties = ExecutorActor.getActiveContext().getAction().getActorProperties();
        Set keySet = actorProperties.keySet();
        for (String property : keySet) {
            if (validSet.contains(property)) continue;
            StringBuffer buffer = new StringBuffer();
            for (String validProperty : validSet) {
                buffer.append(validProperty).append(' ');
            }
            throw new IllegalStateException(NLS.bind((String)Messages.actorProperty_0_invalid_valid_are_1, (Object)property, (Object)buffer.toString()));
        }
    }

    private String getExecCommand() {
        return TextUtils.notEmptyTrimmedString((String)this.getActorProperty(EXECUTOR_EXEC_ACTION));
    }

    private File getExecutionDir(IActionContext ctx) throws CoreException {
        String executionDir = TextUtils.notEmptyTrimmedString((String)this.getActorProperty(EXECUTOR_EXEC_DIR_ACTION));
        String componentLocation = ctx.getComponentLocation().toOSString();
        if (executionDir == null) {
            return new File(componentLocation);
        }
        File executionDirFile = new File(executionDir);
        if (executionDirFile.isAbsolute()) {
            return executionDirFile;
        }
        return new File(String.valueOf(componentLocation) + executionDir);
    }

    private boolean getFailStatus() {
        String failOnErrorValue = this.getActorProperty(EXECUTOR_FAIL_ON_ERROR);
        if (failOnErrorValue == null) {
            return true;
        }
        return Boolean.parseBoolean(TextUtils.notEmptyTrimmedString((String)failOnErrorValue));
    }

    private String getShellCommand() {
        return TextUtils.notEmptyTrimmedString((String)this.getActorProperty(EXECUTOR_SHELL_ACTION));
    }

    protected IStatus internalPerform(IActionContext ctx, IProgressMonitor monitor) throws CoreException {
        monitor = MonitorUtils.ensureNotNull((IProgressMonitor)monitor);
        monitor.beginTask(null, 1);
        monitor.subTask(ctx.getAction().getQualifiedName());
        try {
            this.checkProperties();
            String EXE = "[EXE] ";
            PropertyExpander expander = new PropertyExpander(ctx);
            PrintStream errorStream = ctx.getErrorStream();
            PrintStream outputStream = ctx.getOutputStream();
            File executionDir = this.getExecutionDir(ctx);
            String command = expander.expand(this.prepareCommandLine());
            String[] env = this.prepareEnvironmentVariables(expander);
            CorePlugin.getLogger().info("[EXE] " + NLS.bind((String)Messages.now_executing_0, (Object)command), new Object[0]);
            CorePlugin.getLogger().info("[EXE] " + NLS.bind((String)Messages.in_directory_0, (Object)executionDir), new Object[0]);
            Process proc = Runtime.getRuntime().exec(command, env, executionDir);
            StreamGobblerRedirector errorGobbler = new StreamGobblerRedirector(proc.getErrorStream(), errorStream);
            StreamGobblerRedirector outputGobbler = new StreamGobblerRedirector(proc.getInputStream(), outputStream);
            errorGobbler.start();
            outputGobbler.start();
            int returnCode = proc.waitFor();
            outputStream.flush();
            if (returnCode != 0) {
                CorePlugin.getLogger().error(NLS.bind((String)Messages.program_0_exit_code_1, (Object)command, (Object)String.valueOf(returnCode)), new Object[0]);
                if (this.getFailStatus()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
            }
        }
        catch (IOException e) {
            Throwable t = BuckminsterException.unwind((Throwable)e);
            CorePlugin.getLogger().error(t, t.toString(), new Object[0]);
            Status status = new Status(4, PLUGIN_ID, e.getMessage());
            return status;
        }
        catch (InterruptedException e) {
            Throwable t = BuckminsterException.unwind((Throwable)e);
            CorePlugin.getLogger().error(t, t.toString(), new Object[0]);
            Status status = new Status(4, PLUGIN_ID, e.getMessage());
            return status;
        }
        catch (CoreException e) {
            Throwable t = BuckminsterException.unwind((Throwable)e);
            CorePlugin.getLogger().error(t, t.toString(), new Object[0]);
            throw e;
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private String prepareCommandLine() throws CoreException {
        String execCommand = this.getExecCommand();
        String shellCommand = this.getShellCommand();
        if (execCommand == null && shellCommand == null) {
            this.throwError(NLS.bind((String)Messages.actorProperty_at_least_one_0_1, (Object)EXECUTOR_EXEC_ACTION, (Object)EXECUTOR_SHELL_ACTION));
        }
        if (execCommand != null && shellCommand != null) {
            this.throwError(NLS.bind((String)Messages.actorProperty_at_most_one_0_1, (Object)EXECUTOR_EXEC_ACTION, (Object)EXECUTOR_SHELL_ACTION));
        }
        if (execCommand != null) {
            return execCommand;
        }
        String shell = ShellCommand.getShellCommand();
        if (shell == null) {
            throw new Error(NLS.bind((String)Messages.shell_interpreter_for_0_not_supported, (Object)ShellCommand.getOsName()));
        }
        return String.valueOf(shell) + ' ' + shellCommand;
    }

    private String[] prepareEnvironmentVariables(PropertyExpander expander) throws CoreException {
        Logger logger;
        String ENV = "[ENV] ";
        HashSet<String> envSet = new HashSet<String>();
        String envProperty = TextUtils.notEmptyTrimmedString((String)this.getActorProperty(EXECUTOR_ENV));
        boolean useEnvironment = !Boolean.parseBoolean(this.getActorProperty(EXECUTOR_NEW_ENVIRONMENT_ACTION));
        CorePlugin.getLogger().info("[ENV] " + NLS.bind((String)Messages.using_system_environment_0, (Object)String.valueOf(useEnvironment)), new Object[0]);
        if (useEnvironment) {
            Map<String, String> getenv = System.getenv();
            for (String key : getenv.keySet()) {
                envSet.add(String.valueOf(key) + '=' + getenv.get(key));
            }
        }
        if (envProperty != null) {
            String[] split;
            String[] stringArray = split = ExecutorActor.splitEnvironnementVariables(envProperty);
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String env = stringArray[n2];
                envSet.add(expander.expand(env));
                ++n2;
            }
        }
        if ((logger = CorePlugin.getLogger()).isDebugEnabled() && !envSet.isEmpty()) {
            for (String string : envSet) {
                logger.debug("%sSetting environment variable %s%n", new Object[]{"[ENV] ", string});
            }
        }
        return envSet.toArray(new String[envSet.size()]);
    }

    private void throwError(String message) throws CoreException {
        throw new CoreException((IStatus)new Status(4, PLUGIN_ID, message));
    }
}

