/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.generic.model.tree;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.buckminster.generic.model.tree.BasicTreeParentDataNode;
import org.eclipse.buckminster.generic.model.tree.ITreeDataListener;
import org.eclipse.buckminster.generic.model.tree.ITreeDataNode;
import org.eclipse.buckminster.generic.model.tree.ITreeParentDataNode;
import org.eclipse.buckminster.generic.model.tree.ITreeRootNode;
import org.eclipse.buckminster.generic.model.tree.TreeDataEvent;

public abstract class AbstractTreeRootDataNode
extends BasicTreeParentDataNode
implements ITreeRootNode {
    private final List<ITreeDataListener> m_listeners = new LinkedList<ITreeDataListener>();

    public AbstractTreeRootDataNode(Object data) {
        super(data);
    }

    public void addTreeDataListener(ITreeDataListener listener) {
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    public void childNodeChanged(ITreeDataNode child) {
        this.fireTreeDataChanged(child);
        ITreeParentDataNode parent = this.getParent();
        if (parent != null) {
            parent.childNodeChanged(child);
        }
    }

    public void removeTreeDataListener(ITreeDataListener listener) {
        this.m_listeners.remove(listener);
    }

    protected void fireTreeDataChanged(ITreeDataNode changedNode) {
        this.triggerListeners(TreeDataEvent.changed(this, changedNode));
    }

    protected void inProcTriggerListeners(TreeDataEvent e) {
        ArrayList<ITreeDataListener> listeners = new ArrayList<ITreeDataListener>(this.m_listeners.size());
        listeners.addAll(this.m_listeners);
        for (ITreeDataListener a : listeners) {
            a.treeNodeChanged(e);
        }
    }

    protected abstract void triggerListeners(TreeDataEvent var1);
}

