/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.generic.plugin;

import org.eclipse.buckminster.generic.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginClassHandle<T> {
    private static final String ATT_CLASS = "class";
    protected final IConfigurationElement m_configElement;
    private final Class<T> m_clazz;
    private T m_handle;
    private Plugin m_plugin;

    protected PluginClassHandle(Plugin plugin, IConfigurationElement configElement, Class<T> clazz, String requiredElement) {
        this.m_plugin = plugin;
        this.m_configElement = configElement;
        this.m_clazz = clazz;
        if (!configElement.getName().equals(requiredElement)) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.requiredElement_0_not_correct_expected_1, (Object)configElement.getName(), (Object)requiredElement));
        }
    }

    public synchronized T getHandle() {
        if (this.m_handle != null) {
            return this.m_handle;
        }
        try {
            this.m_handle = this.m_clazz.cast(this.m_configElement.createExecutableExtension(ATT_CLASS));
        }
        catch (CoreException e) {
            this.logLoadError(this.m_configElement, (Exception)((Object)e));
        }
        return this.m_handle;
    }

    protected void logLoadError(IConfigurationElement configElement, Exception e) {
        String name = this.m_configElement.getName();
        String msg = NLS.bind((String)Messages.failed_to_load_extension_point_element_0_in_1, (Object)(name == null ? "[" + Messages.missing_name_attribute + "]" : name), (Object)configElement.getDeclaringExtension().getNamespaceIdentifier());
        ILog log = this.m_plugin.getLog();
        log.log((IStatus)new Status(4, this.m_plugin.getBundle().getSymbolicName(), msg));
    }
}

