/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.generic.utils;

import org.eclipse.buckminster.generic.Messages;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;

public class PluginUtils {
    public static String getAttribute(IConfigurationElement configElement, String name, String defaultValue) {
        String value = configElement.getAttribute(name);
        if (value != null) {
            return value;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.missing_attribute_0, (Object)name));
    }

    public static String[] getAttributeArray(IConfigurationElement configElement, String name) {
        IConfigurationElement[] childElements = configElement.getChildren(name);
        if (childElements.length < 1) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.missing_sequence_0, (Object)name));
        }
        String[] result = new String[childElements.length];
        int i = 0;
        while (i < childElements.length) {
            result[i] = PluginUtils.getAttribute(childElements[i], "name", null);
            ++i;
        }
        return result;
    }
}

