/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.installer;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.buckminster.cmdline.AbstractCommand;
import org.eclipse.buckminster.cmdline.SimpleErrorExitException;
import org.eclipse.buckminster.cmdline.UsageException;
import org.eclipse.buckminster.installer.Messages;
import org.eclipse.buckminster.installer.VersionedIdentifierComparator;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.operations.OperationsManager;

public class Install
extends AbstractCommand {
    private URL m_site;
    private String m_version;
    private String m_feature;

    static URL normalizeToURL(String surl) {
        URL url;
        try {
            url = new URL(surl);
        }
        catch (MalformedURLException e) {
            try {
                url = new File(surl).toURI().toURL();
            }
            catch (MalformedURLException e2) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.URL_0_malformed, (Object)surl));
            }
        }
        return url;
    }

    protected void handleUnparsed(String[] unparsed) throws Exception {
        int len = unparsed.length;
        if (len > 3) {
            throw new UsageException(Messages.too_many_arguments);
        }
        if (len > 0) {
            this.m_site = Install.normalizeToURL(unparsed[0]);
        }
        if (len > 1) {
            this.m_feature = unparsed[1];
        }
        if (len > 2) {
            this.m_version = unparsed[2];
        }
    }

    protected int run(IProgressMonitor monitor) throws Exception {
        if (this.m_site == null) {
            throw new UsageException(Messages.no_site_provided);
        }
        if (this.m_feature == null) {
            throw new UsageException(Messages.no_feature_id_provided);
        }
        IFeature featureToInstall = null;
        VersionedIdentifier vidToFind = new VersionedIdentifier(this.m_feature, this.m_version == null ? "0.0.0" : this.m_version);
        monitor.beginTask(null, -1);
        monitor.subTask(NLS.bind((String)Messages.searching_for_0_in_1_, (Object)vidToFind, (Object)this.m_site));
        ISite site = SiteManager.getSite((URL)this.m_site, (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
        ISiteFeatureReference match = null;
        ISiteFeatureReference[] references = site.getFeatureReferences();
        int idx = references.length;
        while (--idx >= 0) {
            ISiteFeatureReference featureRef = references[idx];
            VersionedIdentifier vid = featureRef.getVersionedIdentifier();
            if (vid.getIdentifier().equals(this.m_feature)) {
                if (this.m_version == null) {
                    if (match == null || VersionedIdentifierComparator.compareStatic(vid, match.getVersionedIdentifier()) > 0) {
                        match = featureRef;
                    }
                } else if (vid.equals((Object)vidToFind)) {
                    match = featureRef;
                    break;
                }
            }
            MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
        }
        if (match == null) {
            throw new SimpleErrorExitException(Messages.no_suitable_feature_version_found);
        }
        featureToInstall = match.getFeature(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
        if (Platform.inDevelopmentMode()) {
            throw new SimpleErrorExitException(Messages.no_install_in_development_mode);
        }
        monitor.subTask(NLS.bind((String)Messages.installing_0_, (Object)featureToInstall.getVersionedIdentifier()));
        IConfiguredSite installSite = null;
        IConfiguredSite[] configuredSites = SiteManager.getLocalSite().getCurrentConfiguration().getConfiguredSites();
        idx = 0;
        while (idx < configuredSites.length) {
            IConfiguredSite configuredSite = configuredSites[idx];
            if (configuredSite.isProductSite() && configuredSite.isUpdatable()) {
                installSite = configuredSite;
                break;
            }
            MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
            ++idx;
        }
        if (installSite == null) {
            throw new SimpleErrorExitException(Messages.site_to_install_to_not_found);
        }
        IStatus brokenStatus = OperationsManager.getValidator().validatePendingInstall(null, featureToInstall);
        if (brokenStatus != null) {
            throw new CoreException(brokenStatus);
        }
        installSite.install(featureToInstall, null, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
        return 0;
    }
}

