/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.installer;

import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.buckminster.cmdline.AbstractCommand;
import org.eclipse.buckminster.cmdline.SimpleErrorExitException;
import org.eclipse.buckminster.installer.Install;
import org.eclipse.buckminster.installer.Messages;
import org.eclipse.buckminster.installer.VersionedIdentifierComparator;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;

public class ListSite
extends AbstractCommand {
    private URL m_site;

    protected void handleUnparsed(String[] unparsed) throws Exception {
        int len = unparsed.length;
        if (len > 1) {
            throw new SimpleErrorExitException(Messages.too_many_arguments);
        }
        if (len == 1) {
            this.m_site = Install.normalizeToURL(unparsed[0]);
        }
    }

    protected int run(IProgressMonitor monitor) throws Exception {
        VersionedIdentifierComparator vidc = VersionedIdentifierComparator.ASCENDING;
        TreeMap<VersionedIdentifier, Object> features = new TreeMap<VersionedIdentifier, Object>(vidc);
        ILocalSite localSite = null;
        try {
            ISite[] sites;
            monitor.beginTask(null, -1);
            monitor.subTask(NLS.bind((String)Messages.searching_0_, (Object)(this.m_site == null ? Messages.local_site : this.m_site.toString())));
            if (this.m_site == null) {
                localSite = SiteManager.getLocalSite();
                IConfiguredSite[] cSites = localSite.getCurrentConfiguration().getConfiguredSites();
                int idx = cSites.length;
                sites = new ISite[idx];
                while (--idx >= 0) {
                    sites[idx] = cSites[idx].getSite();
                }
                MonitorUtils.worked((IProgressMonitor)monitor, (int)1000);
            } else {
                sites = new ISite[]{SiteManager.getSite((URL)this.m_site, (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000))};
                MonitorUtils.testCancelStatus((IProgressMonitor)monitor);
            }
            int idx = 0;
            while (idx < sites.length) {
                ISite site = sites[idx];
                ISiteFeatureReference[] featureRefs = site.getFeatureReferences();
                int refIdx = 0;
                while (refIdx < featureRefs.length) {
                    ISiteFeatureReference featureRef = featureRefs[refIdx];
                    VersionedIdentifier vi = featureRef.getVersionedIdentifier();
                    try {
                        features.put(vi, featureRef.getFeature(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000)));
                    }
                    catch (CoreException e) {
                        features.put(vi, featureRef);
                    }
                    ++refIdx;
                }
                ++idx;
            }
        }
        finally {
            monitor.done();
        }
        System.out.println(Messages.feature_listing_heading);
        for (Map.Entry entry : features.entrySet()) {
            IStatus brokenStatus;
            IAdaptable f = (IAdaptable)entry.getValue();
            System.out.print("  ");
            System.out.print(entry.getKey());
            System.out.print(" (");
            System.out.print(f instanceof IFeature ? ((IFeature)f).getLabel() : ((IFeatureReference)f).getName());
            System.out.println(")");
            if (f instanceof IFeatureReference) {
                System.out.println("    " + Messages.only_reference_found);
                continue;
            }
            if (localSite == null || (brokenStatus = localSite.getFeatureStatus((IFeature)f)).getCode() == 0) continue;
            if (brokenStatus.isMultiStatus()) {
                IStatus[] children = ((MultiStatus)brokenStatus).getChildren();
                int idx = 0;
                while (idx < children.length) {
                    System.out.println("    " + children[idx].getMessage());
                    ++idx;
                }
                continue;
            }
            System.out.println("    " + brokenStatus.getMessage());
        }
        return 0;
    }
}

