/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.installer;

import java.util.ArrayList;
import org.eclipse.buckminster.cmdline.AbstractCommand;
import org.eclipse.buckminster.cmdline.SimpleErrorExitException;
import org.eclipse.buckminster.installer.Messages;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;

public class Uninstall
extends AbstractCommand {
    private String m_version;
    private String m_feature;

    protected void handleUnparsed(String[] unparsed) throws Exception {
        int len = unparsed.length;
        if (len > 2) {
            throw new SimpleErrorExitException(Messages.too_many_arguments);
        }
        if (len > 0) {
            this.m_feature = unparsed[0];
        }
        if (len > 1) {
            this.m_version = unparsed[1];
        }
    }

    protected int run(IProgressMonitor monitor) throws Exception {
        if (this.m_feature == null) {
            throw new SimpleErrorExitException(Messages.no_feature_id_provided);
        }
        monitor.beginTask(null, -1);
        try {
            if (Platform.inDevelopmentMode()) {
                throw new SimpleErrorExitException(Messages.no_uninstall_in_development_mode);
            }
            VersionedIdentifier vidToFind = new VersionedIdentifier(this.m_feature, this.m_version == null ? "0.0.0" : this.m_version);
            monitor.subTask(NLS.bind((String)Messages.searching_for_0_, (Object)vidToFind));
            IConfiguredSite uninstallSite = null;
            IConfiguredSite[] configuredSites = SiteManager.getLocalSite().getCurrentConfiguration().getConfiguredSites();
            int idx = 0;
            while (idx < configuredSites.length) {
                IConfiguredSite configuredSite = configuredSites[idx];
                if (configuredSite.isProductSite() && configuredSite.isUpdatable()) {
                    uninstallSite = configuredSite;
                    break;
                }
                MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
                ++idx;
            }
            if (uninstallSite == null) {
                throw new SimpleErrorExitException(Messages.site_to_uninstall_from_not_found);
            }
            ArrayList<IFeatureReference> matches = new ArrayList<IFeatureReference>();
            IFeatureReference[] featureRefs = uninstallSite.getFeatureReferences();
            int idx2 = 0;
            while (idx2 < featureRefs.length) {
                IFeatureReference featureRef = featureRefs[idx2];
                VersionedIdentifier vid = featureRef.getVersionedIdentifier();
                if (vid.getIdentifier().equals(this.m_feature)) {
                    if (this.m_version == null) {
                        matches.add(featureRef);
                    } else if (vid.equals((Object)vidToFind)) {
                        matches.add(featureRef);
                        break;
                    }
                }
                MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
                ++idx2;
            }
            if (matches.isEmpty()) {
                throw new SimpleErrorExitException(Messages.no_suitable_feature_version_found);
            }
            if (matches.size() > 1) {
                StringBuffer sb = new StringBuffer();
                int idx3 = 0;
                while (idx3 < matches.size()) {
                    sb.append(' ').append(((IFeatureReference)matches.get(idx3)).getVersionedIdentifier().getVersion());
                    ++idx3;
                }
                throw new SimpleErrorExitException(NLS.bind((String)Messages.multiple_versions_found_0, (Object)sb.toString()));
            }
            IFeature featureToUninstall = ((IFeatureReference)matches.get(0)).getFeature(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
            monitor.subTask(NLS.bind((String)Messages.uninstalling_0_, (Object)featureToUninstall.getVersionedIdentifier()));
            if (uninstallSite.isConfigured(featureToUninstall)) {
                uninstallSite.unconfigure(featureToUninstall);
            }
            MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
            uninstallSite.remove(featureToUninstall, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
        }
        finally {
            monitor.done();
        }
        return 0;
    }
}

