/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.jdt;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.reader.ICatalogReader;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IFileReader;
import org.eclipse.buckminster.core.reader.IStreamConsumer;
import org.eclipse.buckminster.jdt.Messages;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathReader
extends JavaProject
implements IStreamConsumer<IClasspathEntry[]> {
    private static Method s_decodeClasspathMethod;
    private static boolean s_isEclipse3_3;

    static {
        s_isEclipse3_3 = false;
    }

    public static IClasspathEntry[] getClasspath(IComponentReader reader, IProgressMonitor monitor) throws CoreException {
        ClasspathReader rdr = new ClasspathReader();
        try {
            return reader instanceof ICatalogReader ? (IClasspathEntry[])((ICatalogReader)reader).readFile(".classpath", (IStreamConsumer)rdr, monitor) : (IClasspathEntry[])((IFileReader)reader).readFile((IStreamConsumer)rdr, monitor);
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    public ClasspathReader() {
        super(ResourcesPlugin.getWorkspace().getRoot().getProject(" "), (JavaElement)JavaModelManager.getJavaModelManager().getJavaModel());
    }

    public IClasspathEntry[] consumeStream(IComponentReader reader, String streamName, InputStream stream, IProgressMonitor monitor) throws CoreException, IOException {
        monitor.beginTask(null, 150);
        monitor.subTask(Messages.parsing_classpath);
        try {
            ByteArrayOutputStream builder = new ByteArrayOutputStream();
            FileUtils.copyFile((InputStream)stream, (OutputStream)builder, (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
            IClasspathEntry[] iClasspathEntryArray = this.myDecodeClasspath(new String(builder.toByteArray()));
            return iClasspathEntryArray;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IClasspathEntry[] myDecodeClasspath(String xmlClasspath) throws CoreException {
        if (s_decodeClasspathMethod == null) {
            Class<JavaProject> c;
            Class<JavaProject> clazz = c = JavaProject.class;
            synchronized (clazz) {
                try {
                    s_decodeClasspathMethod = c.getDeclaredMethod("decodeClasspath", String.class, Map.class);
                    s_isEclipse3_3 = true;
                }
                catch (NoSuchMethodException e) {
                    try {
                        s_decodeClasspathMethod = c.getDeclaredMethod("decodeClasspath", String.class, Boolean.TYPE, Boolean.TYPE);
                        s_isEclipse3_3 = false;
                    }
                    catch (NoSuchMethodException e2) {
                        throw BuckminsterException.wrap((Throwable)e2);
                    }
                }
            }
        }
        try {
            Object[] objectArray;
            if (s_isEclipse3_3) {
                Object[] objectArray2 = new Object[2];
                objectArray = objectArray2;
                objectArray2[0] = xmlClasspath;
            } else {
                Object[] objectArray3 = new Object[3];
                objectArray3[0] = xmlClasspath;
                objectArray3[1] = Boolean.FALSE;
                objectArray = objectArray3;
                objectArray3[2] = Boolean.FALSE;
            }
            Object[] args = objectArray;
            return (IClasspathEntry[])s_decodeClasspathMethod.invoke((Object)this, args);
        }
        catch (Throwable t) {
            throw BuckminsterException.wrap((Throwable)t);
        }
    }
}

