/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.jdt.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.buckminster.core.cspec.ICSpecData;
import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.metadata.ModelCache;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.metadata.model.IModelCache;
import org.eclipse.buckminster.jdt.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BMClasspathContainer
implements IClasspathContainer {
    public static final IPath PATH = new Path("org.eclipse.buckminster.jdt.requiredComponents");
    private final IProject m_project;
    private final IClasspathEntry[] m_entries;

    public BMClasspathContainer(IProject project, String topTarget) throws CoreException {
        this.m_project = project;
        ArrayList<IClasspathEntry> cpes = new ArrayList<IClasspathEntry>();
        CSpec cspec = WorkspaceInfo.getCSpec((IResource)project);
        if (cspec != null) {
            this.addNodeToClassPath(cspec, cpes, (IModelCache)new ModelCache(), new HashSet<ComponentIdentifier>(), 0);
        }
        this.m_entries = cpes.toArray(new IClasspathEntry[cpes.size()]);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BMClasspathContainer)) {
            return false;
        }
        BMClasspathContainer that = (BMClasspathContainer)o;
        return Arrays.equals(this.m_entries, that.m_entries);
    }

    public final IClasspathEntry[] getClasspathEntries() {
        return this.m_entries;
    }

    public String getDescription() {
        return Messages.BMClasspathContainer_description;
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return PATH;
    }

    public int hashCode() {
        return Arrays.hashCode(this.m_entries);
    }

    private void addNodeToClassPath(CSpec cspec, ArrayList<IClasspathEntry> cpes, IModelCache cache, HashSet<ComponentIdentifier> seenIDs, int depth) throws CoreException {
        IClasspathEntry cpe;
        ComponentIdentifier cid = cspec.getComponentIdentifier();
        if (seenIDs.contains(cid)) {
            return;
        }
        seenIDs.add(cid);
        for (ComponentRequest refToChild : cspec.getDependencies()) {
            CSpec childSpec = cache.findCSpec((ICSpecData)cspec, refToChild);
            this.addNodeToClassPath(childSpec, cpes, cache, seenIDs, depth + 1);
        }
        IPath componentHome = cspec.getComponentLocation();
        IProject project = WorkspaceInfo.getProject((IComponentIdentifier)cid);
        if (project != null) {
            if (project.getName().equals(this.m_project.getName())) {
                return;
            }
            if (project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature") && !cpes.contains(cpe = JavaCore.newProjectEntry((IPath)project.getFullPath()))) {
                cpes.add(cpe);
            }
            return;
        }
        if (!componentHome.toFile().isFile()) {
            return;
        }
        if (componentHome.lastSegment().endsWith(".jar") && !cpes.contains(cpe = JavaCore.newLibraryEntry((IPath)componentHome, null, null))) {
            cpes.add(cpe);
        }
    }
}

