/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.jdt.internal;

import org.eclipse.buckminster.jdt.JdtPlugin;
import org.eclipse.buckminster.jdt.internal.BMClasspathContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class BMClasspathInitializer
extends ClasspathContainerInitializer
implements IResourceChangeListener {
    public BMClasspathInitializer() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 8);
    }

    public void initialize(IPath containerPath, IJavaProject javaProject) throws CoreException {
        IClasspathContainer oldCP;
        IProject project;
        BMClasspathContainer newCP;
        if (javaProject == null || !BMClasspathContainer.PATH.isPrefixOf(containerPath)) {
            return;
        }
        String targetDesignator = null;
        if (containerPath.segmentCount() == 2) {
            targetDesignator = containerPath.lastSegment();
        }
        if ((newCP = new BMClasspathContainer(project = javaProject.getProject(), targetDesignator)).equals(oldCP = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)javaProject))) {
            return;
        }
        JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{javaProject}, (IClasspathContainer[])new IClasspathContainer[]{newCP}, null);
        JdtPlugin.getLogger().debug("%s container initialized for project %s", new Object[]{containerPath, project.getName()});
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IPath path = BMClasspathContainer.PATH;
        try {
            IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            IJavaProject[] iJavaProjectArray = model.getJavaProjects();
            int n = iJavaProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaProject javaProject = iJavaProjectArray[n2];
                IClasspathEntry[] iClasspathEntryArray = javaProject.readRawClasspath();
                int n3 = iClasspathEntryArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPath entryPath;
                    IClasspathEntry rawEntry = iClasspathEntryArray[n4];
                    if (rawEntry.getEntryKind() == 5 && path.isPrefixOf(entryPath = rawEntry.getPath())) {
                        this.initialize(entryPath, javaProject);
                        return;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

