/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.jdt.internal;

import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.buckminster.core.build.PropertiesEmitter;
import org.eclipse.buckminster.core.helpers.ArrayUtils;
import org.eclipse.buckminster.jdt.Messages;
import org.eclipse.buckminster.jdt.internal.BMClasspathContainer;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathEmitter
extends PropertiesEmitter {
    public static final String ARG_FORMAT_CLASSPATH = "format.classpath";
    public static final String ARG_TARGET = "target";
    public static final String ARG_PATH_SEPARATOR = "path.separator";
    public static final Format FORMAT_CLASSPATH = new MessageFormat("bm.classpath");
    private static final String s_pathSeparator = System.getProperty("path.separator", ":");

    public static List<IPath> finalClasspathResolve(IProject project, String target) throws CoreException {
        IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        HashSet<IPath> seenPaths = new HashSet<IPath>();
        HashSet<String> seenProjects = new HashSet<String>();
        ArrayList<IPath> finalClasspath = new ArrayList<IPath>();
        ClasspathEmitter.appendPaths(model, project, target, finalClasspath, seenPaths, seenProjects, true);
        return finalClasspath;
    }

    public static IPath getDefaultOutputFolder(IProject project) throws CoreException {
        String projectName = project.getName();
        IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        IJavaProject javaProject = model.getJavaProject(projectName);
        if (javaProject == null || !javaProject.exists()) {
            return null;
        }
        return javaProject.getOutputLocation().removeFirstSegments(1);
    }

    private static void appendPaths(IJavaModel model, IProject project, String target, List<IPath> path, HashSet<IPath> seenPaths, HashSet<String> seenProjects, boolean atTop) throws CoreException {
        IClasspathEntry[] entries;
        String projectName = project.getName();
        if (seenProjects.contains(projectName)) {
            return;
        }
        seenProjects.add(projectName);
        IJavaProject javaProject = model.getJavaProject(projectName);
        if (javaProject == null || !javaProject.exists()) {
            BMClasspathContainer container = new BMClasspathContainer(project, target);
            entries = container.getClasspathEntries();
        } else {
            entries = atTop && target != null ? ClasspathEmitter.changeClasspathForTarget(javaProject, target) : javaProject.getResolvedClasspath(false);
        }
        ArrayList<Object> resolvedEntries = new ArrayList<Object>();
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry iClasspathEntry = iClasspathEntryArray[n2];
            switch (iClasspathEntry.getEntryKind()) {
                case 4: {
                    try {
                        IClasspathEntry resolvedEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)iClasspathEntry);
                        if (resolvedEntry == null) break;
                        resolvedEntries.add(resolvedEntry);
                    }
                    catch (AssertionFailedException resolvedEntry) {}
                    break;
                }
                case 5: {
                    IClasspathEntry[] containerEntries;
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)iClasspathEntry.getPath(), (IJavaProject)javaProject);
                    if (container == null || (containerEntries = container.getClasspathEntries()) == null) break;
                    int top = containerEntries.length;
                    int idx = 0;
                    while (idx < top) {
                        ClasspathEntry cEntry = (ClasspathEntry)containerEntries[idx];
                        resolvedEntries.add(cEntry.combineWith((ClasspathEntry)iClasspathEntry));
                        ++idx;
                    }
                    break;
                }
                default: {
                    resolvedEntries.add(iClasspathEntry);
                }
            }
            ++n2;
        }
        block13: for (IClasspathEntry iClasspathEntry : resolvedEntries) {
            IPath entryPath;
            switch (iClasspathEntry.getEntryKind()) {
                case 1: {
                    if (!atTop && !iClasspathEntry.isExported()) continue block13;
                    entryPath = iClasspathEntry.getPath();
                    break;
                }
                case 3: {
                    entryPath = iClasspathEntry.getOutputLocation();
                    if (entryPath != null) break;
                    IJavaProject proj = model.getJavaProject(iClasspathEntry.getPath().segment(0));
                    if (proj == null) continue block13;
                    entryPath = proj.getOutputLocation();
                    break;
                }
                case 2: {
                    if (!atTop && !iClasspathEntry.isExported()) continue block13;
                    IProject conProject = ResourcesPlugin.getWorkspace().getRoot().getProject(iClasspathEntry.getPath().segment(0));
                    ClasspathEmitter.appendPaths(model, conProject, null, path, seenPaths, seenProjects, false);
                    continue block13;
                }
                default: {
                    throw BuckminsterException.fromMessage((String)Messages.unexpected_classpath_entry_kind, (Object[])new Object[0]);
                }
            }
            IResource folder = ResourcesPlugin.getWorkspace().getRoot().findMember(entryPath);
            if (folder != null) {
                entryPath = folder.getLocation();
            }
            if (seenPaths.contains(entryPath)) continue;
            seenPaths.add(entryPath);
            path.add(entryPath);
        }
    }

    private static IClasspathEntry[] changeClasspathForTarget(IJavaProject javaProject, String target) throws CoreException {
        boolean entriesChanged = false;
        boolean haveOtherBMCPs = false;
        boolean targetContainerInstalled = false;
        IPath desiredContainer = BMClasspathContainer.PATH.append(target);
        Object[] rawEntries = javaProject.readRawClasspath();
        int top = rawEntries.length;
        int idx = 0;
        while (idx < top) {
            IPath entryPath;
            IClasspathEntry rawEntry = rawEntries[idx];
            if (rawEntry.getEntryKind() == 5 && BMClasspathContainer.PATH.isPrefixOf(entryPath = rawEntry.getPath())) {
                if (!targetContainerInstalled) {
                    if (!desiredContainer.equals((Object)entryPath)) {
                        rawEntries[idx] = JavaCore.newContainerEntry((IPath)desiredContainer);
                        entriesChanged = true;
                    }
                    targetContainerInstalled = true;
                } else {
                    haveOtherBMCPs = true;
                }
            }
            ++idx;
        }
        if (targetContainerInstalled) {
            if (haveOtherBMCPs) {
                ArrayList<Object> newEntries = new ArrayList<Object>(top);
                int idx2 = 0;
                while (idx2 < top) {
                    Object rawEntry = rawEntries[idx2];
                    if (rawEntry.getEntryKind() != 5 || rawEntry.getPath().equals((Object)desiredContainer)) {
                        newEntries.add(rawEntry);
                    }
                    ++idx2;
                }
                rawEntries = newEntries.toArray(new IClasspathEntry[newEntries.size()]);
                entriesChanged = true;
            }
        } else {
            rawEntries = (IClasspathEntry[])ArrayUtils.appendFirst((Object[])rawEntries, (Object[])new IClasspathEntry[]{JavaCore.newContainerEntry((IPath)desiredContainer)});
            entriesChanged = true;
        }
        return entriesChanged ? ClasspathEmitter.getResolvedClasspath(javaProject, (IClasspathEntry[])rawEntries) : javaProject.getResolvedClasspath(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IClasspathEntry[] getResolvedClasspath(IJavaProject project, IClasspathEntry[] entries) throws CoreException {
        ArrayList<IClasspathEntry> resolvedEntries = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                IClasspathEntry rawEntry = iClasspathEntryArray[n2];
                switch (rawEntry.getEntryKind()) {
                    case 4: {
                        IClasspathEntry resolvedEntry = null;
                        try {
                            resolvedEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)rawEntry);
                        }
                        catch (AssertionFailedException assertionFailedException) {
                            // empty catch block
                        }
                        if (resolvedEntry != null) break;
                        throw new JavaModelException(ClasspathEntry.validateClasspathEntry((IJavaProject)project, (IClasspathEntry)rawEntry, (boolean)false, (boolean)false));
                    }
                    case 5: {
                        IPath entryPath = rawEntry.getPath();
                        IClasspathContainer container = BMClasspathContainer.PATH.isPrefixOf(entryPath) ? new BMClasspathContainer(project.getProject(), entryPath.segmentCount() > 1 ? entryPath.lastSegment() : null) : JavaCore.getClasspathContainer((IPath)entryPath, (IJavaProject)project);
                        if (container == null) {
                            throw new JavaModelException(ClasspathEntry.validateClasspathEntry((IJavaProject)project, (IClasspathEntry)rawEntry, (boolean)false, (boolean)false));
                        }
                        IClasspathEntry[] containerEntries = container.getClasspathEntries();
                        if (containerEntries != null) {
                            IClasspathEntry[] iClasspathEntryArray2 = containerEntries;
                            int n3 = containerEntries.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IClasspathEntry cEntry = iClasspathEntryArray2[n4];
                                cEntry = ((ClasspathEntry)cEntry).combineWith((ClasspathEntry)rawEntry);
                                resolvedEntries.add(cEntry);
                                ++n4;
                            }
                        }
                        break block10;
                    }
                }
                resolvedEntries.add(rawEntry);
            }
            ++n2;
        }
        return resolvedEntries.toArray(new IClasspathEntry[resolvedEntries.size()]);
    }

    protected void addFormatters() {
        this.addFormat(ARG_FORMAT_CLASSPATH, FORMAT_CLASSPATH);
    }

    protected void appendProperties() throws CoreException {
        IProject project = this.getProject();
        StringBuilder bld = new StringBuilder();
        String target = this.getArgument(ARG_TARGET);
        String pathSep = this.getArgument(ARG_PATH_SEPARATOR);
        if (pathSep == null) {
            pathSep = s_pathSeparator;
        }
        for (IPath location : ClasspathEmitter.finalClasspathResolve(project, target)) {
            if (bld.length() > 0) {
                bld.append(s_pathSeparator);
            }
            bld.append(this.formatPath(location));
        }
        this.addProperty(ARG_FORMAT_CLASSPATH, new String[]{project.getName(), target}, bld.toString());
    }
}

