/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.jdt.internal;

import org.eclipse.buckminster.sax.ISaxable;
import org.eclipse.buckminster.sax.ISaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SaxableClasspath
implements ISaxable {
    private final IClasspathEntry[] m_entries;
    private final IPath m_projectPath;

    private static void emitAccessRule(IAccessRule accessRule, ContentHandler receiver) throws SAXException {
        String kindString;
        AttributesImpl attrs = new AttributesImpl();
        Utils.addAttribute((AttributesImpl)attrs, (String)"pattern", (String)accessRule.getPattern().toString());
        switch (accessRule.getKind()) {
            case 1: {
                kindString = "nonaccessible";
                break;
            }
            case 2: {
                kindString = "discouraged";
                break;
            }
            default: {
                kindString = "accessible";
            }
        }
        Utils.addAttribute((AttributesImpl)attrs, (String)"kind", (String)kindString);
        if (accessRule.ignoreIfBetter()) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"ignoreifbetter", (String)"true");
        }
        receiver.startElement("", "", "accessrule", attrs);
        receiver.endElement("", "", "accessrule");
    }

    private static void emitAttribute(IClasspathAttribute attribute, ContentHandler receiver) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        Utils.addAttribute((AttributesImpl)attrs, (String)"name", (String)attribute.getName());
        Utils.addAttribute((AttributesImpl)attrs, (String)"value", (String)attribute.getValue());
        receiver.startElement("", "", "attribute", attrs);
        receiver.endElement("", "", "attribute");
    }

    private static void encodePatterns(IPath[] patterns, String tag, AttributesImpl attrs) {
        int top;
        if (patterns != null && (top = patterns.length) > 0) {
            StringBuilder rule = new StringBuilder(10);
            rule.append(patterns[0]);
            int idx = 1;
            while (idx < top) {
                rule.append('|');
                rule.append(patterns[idx]);
                ++idx;
            }
            Utils.addAttribute((AttributesImpl)attrs, (String)tag, (String)rule.toString());
        }
    }

    private static String kindToString(int kind) {
        String kindStr;
        switch (kind) {
            case 2: 
            case 3: {
                kindStr = "src";
                break;
            }
            case 1: {
                kindStr = "lib";
                break;
            }
            case 4: {
                kindStr = "var";
                break;
            }
            case 5: {
                kindStr = "con";
                break;
            }
            case 10: {
                kindStr = "output";
                break;
            }
            default: {
                kindStr = "unknown";
            }
        }
        return kindStr;
    }

    public SaxableClasspath(IPath projectPath, IClasspathEntry[] entries) {
        this.m_projectPath = projectPath;
        this.m_entries = entries;
    }

    public void toSax(ContentHandler receiver) throws SAXException {
        receiver.startDocument();
        receiver.startElement("", "", "classpath", ISaxableElement.EMPTY_ATTRIBUTES);
        IClasspathEntry[] iClasspathEntryArray = this.m_entries;
        int n = this.m_entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            this.emitEntry(entry, receiver);
            ++n2;
        }
        receiver.endElement("", "", "classpath");
        receiver.endDocument();
    }

    private void emitEntry(IClasspathEntry entry, ContentHandler receiver) throws SAXException {
        IAccessRule[] accessRules;
        int n;
        IPath outputLocation;
        AttributesImpl attrs = new AttributesImpl();
        int entryKind = entry.getEntryKind();
        Utils.addAttribute((AttributesImpl)attrs, (String)"kind", (String)SaxableClasspath.kindToString(entryKind));
        IPath xmlPath = this.makeProjectRelative(entry.getPath(), entryKind);
        if (xmlPath != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"path", (String)xmlPath.toString());
        }
        if ((xmlPath = this.makeProjectRelative(entry.getSourceAttachmentPath(), entryKind)) != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"sourcepath", (String)xmlPath.toString());
        }
        if ((xmlPath = entry.getSourceAttachmentRootPath()) != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"rootpath", (String)xmlPath.toString());
        }
        if (entry.isExported()) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"exported", (String)"true");
        }
        SaxableClasspath.encodePatterns(entry.getInclusionPatterns(), "including", attrs);
        SaxableClasspath.encodePatterns(entry.getExclusionPatterns(), "excluding", attrs);
        if (entryKind == 2 && !entry.combineAccessRules()) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"combineaccessrules", (String)"false");
        }
        if ((outputLocation = entry.getOutputLocation()) != null) {
            outputLocation = outputLocation.removeFirstSegments(1);
            Utils.addAttribute((AttributesImpl)attrs, (String)"output", (String)String.valueOf(outputLocation));
        }
        receiver.startElement("", "", "classpathentry", attrs);
        IClasspathAttribute[] attributes = entry.getExtraAttributes();
        if (attributes.length > 0) {
            receiver.startElement("", "", "attributes", ISaxableElement.EMPTY_ATTRIBUTES);
            IClasspathAttribute[] iClasspathAttributeArray = attributes;
            n = attributes.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathAttribute attribute = iClasspathAttributeArray[n2];
                SaxableClasspath.emitAttribute(attribute, receiver);
                ++n2;
            }
            receiver.endElement("", "", "attributes");
        }
        if ((accessRules = entry.getAccessRules()).length > 0) {
            receiver.startElement("", "", "accessrules", ISaxableElement.EMPTY_ATTRIBUTES);
            IAccessRule[] iAccessRuleArray = accessRules;
            int n3 = accessRules.length;
            n = 0;
            while (n < n3) {
                IAccessRule accessRule = iAccessRuleArray[n];
                SaxableClasspath.emitAccessRule(accessRule, receiver);
                ++n;
            }
            receiver.endElement("", "", "accessrules");
        }
        receiver.endElement("", "", "classpathentry");
    }

    private IPath makeProjectRelative(IPath path, int entryKind) {
        if (path == null || !path.isAbsolute()) {
            return path;
        }
        if (entryKind == 4 || entryKind == 5) {
            return path;
        }
        if (this.m_projectPath == null || !this.m_projectPath.isPrefixOf(path)) {
            return path;
        }
        return path.removeFirstSegments(this.m_projectPath.segmentCount()).setDevice(null);
    }
}

