/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.jdt.internal.actor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.ant.actor.AntActor;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.cspec.PathGroup;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.jdt.internal.ClasspathEmitter;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdtAntActor
extends AntActor {
    public static final String ACTOR_ID = "jdt.ant";
    public static final String PROPERTY_PROJECT_CLASSPATH = "project.classpath";

    protected void addActorPathGroups(IActionContext ctx, Map<String, PathGroup[]> namedPathGroupArrays) throws CoreException {
        IProject project = WorkspaceInfo.getProject((IComponentIdentifier)ctx.getCSpec().getComponentIdentifier());
        if (project == null) {
            return;
        }
        List<IPath> paths = ClasspathEmitter.finalClasspathResolve(project, null);
        int top = paths.size();
        if (top > 0) {
            ArrayList bld;
            HashMap<IPath, ArrayList<Path>> blds = new HashMap<IPath, ArrayList<Path>>();
            int idx = 0;
            while (idx < top) {
                Path relPath = null;
                IPath path = paths.get(idx);
                if (path.toFile().isFile()) {
                    relPath = new Path(path.lastSegment());
                    path = path.removeLastSegments(1);
                }
                if ((bld = (ArrayList)blds.get(path)) == null) {
                    bld = new ArrayList();
                    blds.put(path, bld);
                }
                if (relPath != null) {
                    bld.add(relPath);
                }
                ++idx;
            }
            ArrayList<PathGroup> pgs = new ArrayList<PathGroup>();
            for (Map.Entry entry : blds.entrySet()) {
                bld = (ArrayList)entry.getValue();
                int nPaths = bld.size();
                IPath[] blda = nPaths == 0 ? Trivial.EMPTY_PATH_ARRAY : bld.toArray(new IPath[nPaths]);
                pgs.add(new PathGroup((IPath)entry.getKey(), blda));
            }
            namedPathGroupArrays.put(PROPERTY_PROJECT_CLASSPATH, pgs.toArray(new PathGroup[pgs.size()]));
        }
    }
}

