/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.opml.model;

import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.buckminster.opml.IHead;
import org.eclipse.buckminster.opml.builder.HeadBuilder;
import org.eclipse.buckminster.sax.AbstractSaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Head
extends AbstractSaxableElement
implements IHead {
    public static final String ELEM_DATE_CREATED = "dateCreated";
    public static final String ELEM_DATE_MODIFIED = "dateModified";
    public static final String ELEM_DOCS = "docs";
    public static final String ELEM_EXPANSION_STATE = "expansionState";
    public static final String ELEM_OWNER_EMAIL = "ownerEmail";
    public static final String ELEM_OWNER_ID = "ownerId";
    public static final String ELEM_OWNER_NAME = "ownerName";
    public static final String ELEM_TITLE = "title";
    public static final String ELEM_VERT_SCROLL_STATE = "vertScrollState";
    public static final String ELEM_WINDOW_BOTTOM = "windowBottom";
    public static final String ELEM_WINDOW_LEFT = "windowLeft";
    public static final String ELEM_WINDOW_RIGHT = "windowRight";
    public static final String ELEM_WINDOW_TOP = "windowTop";
    public static final DateFormat RFC_822_4DY_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US);
    public static final DateFormat RFC_822_FORMAT = new SimpleDateFormat("EEE, d MMM yy HH:mm:ss Z", Locale.US);
    public static final String TAG = "head";
    private final Date m_dateCreated;
    private final Date m_dateModified;
    private final URI m_docs;
    private final int[] m_expansionState;
    private final String m_ownerEmail;
    private final URI m_ownerId;
    private final String m_ownerName;
    private final String m_title;
    private final int m_vertScrollState;
    private final int m_windowBottom;
    private final int m_windowLeft;
    private final int m_windowRight;
    private final int m_windowTop;

    public Head(HeadBuilder head) {
        this.m_dateCreated = head.getDateCreated();
        this.m_docs = head.getDocs();
        this.m_expansionState = head.getExpansionState();
        this.m_dateModified = head.getDateModified();
        this.m_ownerEmail = head.getOwnerEmail();
        this.m_ownerName = head.getOwnerName();
        this.m_ownerId = head.getOwnerId();
        this.m_title = head.getTitle();
        this.m_vertScrollState = head.getVertScrollState();
        this.m_windowBottom = head.getWindowBottom();
        this.m_windowLeft = head.getWindowLeft();
        this.m_windowRight = head.getWindowRight();
        this.m_windowTop = head.getWindowTop();
    }

    public Date getDateCreated() {
        return this.m_dateCreated;
    }

    public Date getDateModified() {
        return this.m_dateModified;
    }

    public String getDefaultTag() {
        return TAG;
    }

    public URI getDocs() {
        return this.m_docs;
    }

    public int[] getExpansionState() {
        return this.m_expansionState;
    }

    public String getOwnerEmail() {
        return this.m_ownerEmail;
    }

    public URI getOwnerId() {
        return this.m_ownerId;
    }

    public String getOwnerName() {
        return this.m_ownerName;
    }

    public String getTitle() {
        return this.m_title;
    }

    public int getVertScrollState() {
        return this.m_vertScrollState;
    }

    public int getWindowBottom() {
        return this.m_windowBottom;
    }

    public int getWindowLeft() {
        return this.m_windowLeft;
    }

    public int getWindowRight() {
        return this.m_windowRight;
    }

    public int getWindowTop() {
        return this.m_windowTop;
    }

    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        this.emitString(handler, namespace, prefix, ELEM_TITLE, this.m_title);
        this.emitDate(handler, namespace, prefix, ELEM_DATE_CREATED, this.m_dateCreated);
        this.emitDate(handler, namespace, prefix, ELEM_DATE_MODIFIED, this.m_dateModified);
        this.emitString(handler, namespace, prefix, ELEM_OWNER_NAME, this.m_ownerName);
        this.emitString(handler, namespace, prefix, ELEM_OWNER_EMAIL, this.m_ownerEmail);
        this.emitString(handler, namespace, prefix, ELEM_OWNER_ID, this.m_ownerId);
        this.emitString(handler, namespace, prefix, ELEM_DOCS, this.m_docs);
        this.emitIntList(handler, namespace, prefix, ELEM_EXPANSION_STATE, this.m_expansionState);
        this.emitInt(handler, namespace, prefix, ELEM_VERT_SCROLL_STATE, this.m_vertScrollState);
        this.emitInt(handler, namespace, prefix, ELEM_WINDOW_TOP, this.m_windowTop);
        this.emitInt(handler, namespace, prefix, ELEM_WINDOW_LEFT, this.m_windowLeft);
        this.emitInt(handler, namespace, prefix, ELEM_WINDOW_BOTTOM, this.m_windowBottom);
        this.emitInt(handler, namespace, prefix, ELEM_WINDOW_RIGHT, this.m_windowRight);
    }

    private void emitDate(ContentHandler handler, String namespace, String prefix, String elemName, Date date) throws SAXException {
        if (date != null) {
            this.emitString(handler, namespace, prefix, elemName, RFC_822_4DY_FORMAT.format(date));
        }
    }

    private void emitInt(ContentHandler handler, String namespace, String prefix, String elemName, int value) throws SAXException {
        if (value != 0) {
            this.emitString(handler, namespace, prefix, elemName, Integer.toString(value));
        }
    }

    private void emitIntList(ContentHandler handler, String namespace, String prefix, String elemName, int[] value) throws SAXException {
        if (value == null) {
            return;
        }
        int top = value.length;
        if (top > 0) {
            StringBuilder bld = new StringBuilder(top * 3);
            bld.append(value[0]);
            int idx = 1;
            while (idx < top) {
                bld.append(',');
                bld.append(value[idx]);
                ++idx;
            }
            this.emitString(handler, namespace, prefix, elemName, bld.toString());
        }
    }

    private void emitString(ContentHandler handler, String namespace, String prefix, String elemName, Object value) throws SAXException {
        if (value == null) {
            return;
        }
        String qName = Utils.makeQualifiedName((String)prefix, (String)elemName);
        handler.startElement(namespace, elemName, qName, EMPTY_ATTRIBUTES);
        char[] chars = value.toString().toCharArray();
        if (chars.length > 0) {
            handler.characters(chars, 0, chars.length);
        }
        handler.endElement(namespace, elemName, qName);
    }
}

