/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.opml.parser;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.buckminster.opml.Messages;
import org.eclipse.buckminster.opml.builder.OPMLBuilder;
import org.eclipse.buckminster.opml.model.OPML;
import org.eclipse.buckminster.opml.parser.OPMLHandler;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.ChildPoppedListener;
import org.eclipse.buckminster.sax.TopHandler;
import org.eclipse.buckminster.sax.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class OPMLParser
extends TopHandler
implements ChildPoppedListener,
ErrorHandler {
    private final URL m_schemaURL;
    private OPMLBuilder m_opml;

    public OPMLParser(boolean validating) throws SAXException {
        super(Utils.createXMLReader((boolean)validating, (boolean)false));
        XMLReader reader = this.getXMLReader();
        if (validating) {
            reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            reader.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        }
        this.setNamespaceAware(false);
        this.setErrorHandler(this);
        this.m_schemaURL = OPMLParser.class.getResource("/opml-2.0.xsd");
        if (this.m_schemaURL == null) {
            throw new SAXException(Messages.unable_to_find_XMLschema_for_opml);
        }
    }

    public void childPopped(ChildHandler child) throws SAXException {
        this.m_opml = ((OPMLHandler)child).getOPML();
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    public OPML parseInput(String systemId, InputStream input) throws SAXException, IOException {
        if (!(input instanceof BufferedInputStream) && !(input instanceof ByteArrayInputStream)) {
            input = new BufferedInputStream(input);
        }
        InputSource source = new InputSource(input);
        if (systemId != null) {
            source.setSystemId(systemId);
        }
        XMLReader reader = this.getXMLReader();
        try {
            reader.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", this.m_schemaURL.toString());
            reader.parse(source);
        }
        finally {
            this.getXMLReader().setContentHandler((ContentHandler)((Object)this));
        }
        return new OPML(this.m_opml);
    }

    public void startDocument() throws SAXException {
        super.startDocument();
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        if ("opml".equals(qName)) {
            OPMLHandler rmh = new OPMLHandler((AbstractHandler)this);
            this.pushHandler(rmh, attrs);
        } else {
            super.startElement(uri, localName, qName, attrs);
        }
    }

    public void warning(SAXParseException e) throws SAXException {
        throw e;
    }
}

