/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.osgi.filter.impl;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class FilterImpl
implements Filter {
    static final int LESS = 4;
    static final int PRESENT = 5;
    static final int SUBSTRING = 6;
    static final int AND = 7;
    static final int OR = 8;
    static final int NOT = 9;
    private final int m_op;
    static final int EQUAL = 1;
    static final int APPROX = 2;
    static final int GREATER = 3;
    private final String m_attr;
    private volatile transient String m_filterString;
    private final boolean m_topLevel;

    static String approxString(String input) {
        boolean changed = false;
        char[] output = input.toCharArray();
        int cursor = 0;
        int i = 0;
        int length = output.length;
        while (i < length) {
            char c = output[i];
            if (Character.isWhitespace(c)) {
                changed = true;
            } else {
                output[cursor] = c;
                ++cursor;
            }
            ++i;
        }
        return changed ? new String(output, 0, cursor) : input;
    }

    static String encodeValue(String value) {
        int inlen = value.length();
        char[] output = null;
        int cursor = 0;
        int i = 0;
        while (i < inlen) {
            char c = value.charAt(i);
            switch (c) {
                case '(': 
                case ')': 
                case '*': 
                case '\\': {
                    if (output == null) {
                        output = new char[inlen << 2];
                        if (i > 0) {
                            value.getChars(0, i, output, 0);
                            cursor = i;
                        }
                    }
                    output[cursor++] = 92;
                }
            }
            if (output != null) {
                output[cursor++] = c;
            }
            ++i;
        }
        return output == null ? value : new String(output, 0, cursor);
    }

    FilterImpl(boolean topLevel, int operation, String attr) {
        this.m_topLevel = topLevel;
        this.m_op = operation;
        this.m_attr = attr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConsultedAttributes(Map<String, String[]> propertyChoices) {
        String stringValue = this.getValueAsString();
        Map<String, String[]> map = propertyChoices;
        synchronized (map) {
            int top;
            String[] choices = propertyChoices.get(this.getAttr());
            if (choices == null) {
                propertyChoices.put(this.getAttr(), new String[]{stringValue});
                return;
            }
            int idx = top = choices.length;
            while (--idx >= 0) {
                if (!stringValue.equals(choices[idx])) continue;
                return;
            }
            String[] newChoices = new String[top + 1];
            System.arraycopy(choices, 0, newChoices, 0, top);
            newChoices[top] = stringValue;
            propertyChoices.put(this.getAttr(), newChoices);
        }
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Filter && this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return 11 * this.toString().hashCode();
    }

    public boolean match(Dictionary properties) {
        return this.match(properties, false);
    }

    @Override
    public boolean match(Map<String, ? extends Object> properties) {
        return this.match0((Map<String, ? extends Object>)(properties == null ? Collections.emptyMap() : new CaseInsensitiveMap<Object>(properties)));
    }

    public boolean match(ServiceReference reference) {
        return this.match0(reference == null ? Collections.emptyMap() : new ServiceReferenceMap(reference));
    }

    public boolean matchCase(Dictionary dictionary) {
        return this.match(dictionary, true);
    }

    @Override
    public boolean matchCase(Map<String, ? extends Object> properties) {
        return this.match0(properties == null ? Collections.emptyMap() : properties);
    }

    public String toString() {
        String result = this.m_filterString;
        if (result == null) {
            StringBuilder bld = new StringBuilder();
            this.toString(bld);
            result = bld.toString();
            if (this.m_topLevel) {
                this.m_filterString = result;
            }
        }
        return result;
    }

    final boolean compare(Object value1) {
        if (value1 == null) {
            return false;
        }
        if (value1 instanceof Collection) {
            Iterator iterator = ((Collection)value1).iterator();
            while (iterator.hasNext()) {
                if (!this.compare(iterator.next())) continue;
                return true;
            }
            return false;
        }
        if (value1 instanceof Object[]) {
            Object[] array = (Object[])value1;
            int i = 0;
            int size = array.length;
            while (i < size) {
                if (this.compare(array[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return this.internalCompare(value1);
    }

    String getAttr() {
        return this.m_attr;
    }

    int getOp() {
        return this.m_op;
    }

    String getValueAsString() {
        return null;
    }

    boolean internalCompare(Object value) {
        return false;
    }

    abstract boolean match0(Map<String, ? extends Object> var1);

    abstract void toString(StringBuilder var1);

    private boolean match(Dictionary dictionary, boolean caseSensitive) {
        AbstractMap props = null;
        if (dictionary instanceof Map) {
            props = (DictionaryMap)((Object)dictionary);
            if (!caseSensitive) {
                props = new CaseInsensitiveMap<Object>(props);
            }
        } else {
            props = dictionary == null ? Collections.emptyMap() : new DictionaryMap(dictionary, caseSensitive);
        }
        return this.match0(props);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CaseInsensitiveMap<V>
    extends AbstractMap<String, V> {
        private final Map<String, String> m_ciMap;
        private final Map<String, ? extends V> m_map;

        CaseInsensitiveMap(Map<String, ? extends V> map) {
            int top = map.size();
            HashMap<String, String> ciMap = null;
            for (String key : map.keySet()) {
                String lowKey;
                if (key == (lowKey = key.toLowerCase())) continue;
                if (ciMap == null) {
                    ciMap = new HashMap<String, String>(top);
                }
                if (ciMap.put(lowKey, key) == null && !map.containsKey(lowKey)) continue;
                throw new IllegalArgumentException("case variants of key: " + lowKey);
            }
            this.m_ciMap = ciMap;
            this.m_map = map;
        }

        @Override
        public Set<Map.Entry<String, V>> entrySet() {
            return this.m_map.entrySet();
        }

        @Override
        public V get(Object key) {
            String realKey;
            String stringKey = ((String)key).toLowerCase();
            if (this.m_ciMap != null && (realKey = this.m_ciMap.get(stringKey)) != null) {
                stringKey = realKey;
            }
            return this.m_map.get(stringKey);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DictionaryMap
    extends HashMap<String, Object> {
        private final boolean m_caseSensitive;

        DictionaryMap(Dictionary<String, ? extends Object> dictionary, boolean caseSensitive) {
            super(dictionary.size());
            Enumeration<String> keys = dictionary.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                Object value = dictionary.get(key);
                if (!caseSensitive) {
                    String lowKey = key.toLowerCase();
                    if (this.containsKey(lowKey)) {
                        throw new IllegalArgumentException("case variants of key: " + lowKey);
                    }
                    key = lowKey;
                }
                this.put(key, value);
            }
            this.m_caseSensitive = caseSensitive;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object get(Object key) {
            return this.m_caseSensitive ? super.get(key) : super.get(((String)key).toLowerCase());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ServiceReferenceMap
    extends AbstractMap<String, Object> {
        private final ServiceReference m_reference;

        ServiceReferenceMap(ServiceReference reference) {
            this.m_reference = reference;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object get(Object key) {
            return this.m_reference.getProperty((String)key);
        }
    }
}

