/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.osgi.filter.impl;

import java.util.ArrayList;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.osgi.filter.impl.AndOrFilterImpl;
import org.eclipse.buckminster.osgi.filter.impl.FilterImpl;
import org.eclipse.buckminster.osgi.filter.impl.Messages;
import org.eclipse.buckminster.osgi.filter.impl.NotFilterImpl;
import org.eclipse.buckminster.osgi.filter.impl.PresentFilterImpl;
import org.eclipse.buckminster.osgi.filter.impl.StringFilterImpl;
import org.eclipse.buckminster.osgi.filter.impl.SubstringFilterImpl;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.InvalidSyntaxException;

public class Parser {
    private final String m_filter;
    private final StringBuilder m_sb = new StringBuilder();
    private int m_pos;

    public static Filter parse(String filterString) throws InvalidSyntaxException {
        return new Parser(filterString).internalParse();
    }

    private Parser(String filter) {
        this.m_filter = filter;
        this.m_pos = 0;
    }

    private Filter internalParse() throws InvalidSyntaxException {
        try {
            FilterImpl filter = this.parse_filter(true);
            if (this.m_pos != this.m_filter.length()) {
                throw this.syntaxException(Messages.FILTER_TRAILING_CHARACTERS);
            }
            return filter;
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new InvalidSyntaxException(NLS.bind((String)Messages.FILTER_PREMATURE_END, (Object)this.m_filter), this.m_filter);
        }
    }

    private FilterImpl parse_and(boolean topLevel) throws InvalidSyntaxException {
        this.skipWhiteSpace();
        char c = this.m_filter.charAt(this.m_pos);
        if (c != '(') {
            throw this.syntaxException(Messages.FILTER_MISSING_LEFTPAREN);
        }
        ArrayList<FilterImpl> operands = new ArrayList<FilterImpl>(10);
        while (c == '(') {
            FilterImpl child = this.parse_filter(false);
            operands.add(child);
            c = this.m_filter.charAt(this.m_pos);
        }
        return new AndOrFilterImpl(topLevel, 7, null, operands.toArray(new FilterImpl[operands.size()]));
    }

    private String parse_attr() throws InvalidSyntaxException {
        this.skipWhiteSpace();
        int begin = this.m_pos;
        int end = this.m_pos;
        char c = this.m_filter.charAt(begin);
        while (c != '~' && c != '<' && c != '>' && c != '=' && c != '(' && c != ')') {
            ++this.m_pos;
            if (!Character.isWhitespace(c)) {
                end = this.m_pos;
            }
            c = this.m_filter.charAt(this.m_pos);
        }
        if (end == begin) {
            throw this.syntaxException(Messages.FILTER_MISSING_ATTR);
        }
        return this.m_filter.substring(begin, end);
    }

    private FilterImpl parse_filter(boolean topLevel) throws InvalidSyntaxException {
        this.skipWhiteSpace();
        if (this.m_filter.charAt(this.m_pos) != '(') {
            throw this.syntaxException(Messages.FILTER_MISSING_LEFTPAREN);
        }
        ++this.m_pos;
        FilterImpl filter = this.parse_filtercomp(topLevel);
        this.skipWhiteSpace();
        if (this.m_filter.charAt(this.m_pos) != ')') {
            throw this.syntaxException(Messages.FILTER_MISSING_RIGHTPAREN);
        }
        ++this.m_pos;
        this.skipWhiteSpace();
        return filter;
    }

    private FilterImpl parse_filtercomp(boolean topLevel) throws InvalidSyntaxException {
        this.skipWhiteSpace();
        char c = this.m_filter.charAt(this.m_pos);
        switch (c) {
            case '&': {
                ++this.m_pos;
                return this.parse_and(topLevel);
            }
            case '|': {
                ++this.m_pos;
                return this.parse_or(topLevel);
            }
            case '!': {
                ++this.m_pos;
                return this.parse_not(topLevel);
            }
        }
        return this.parse_item(topLevel);
    }

    private FilterImpl parse_item(boolean topLevel) throws InvalidSyntaxException {
        String attr = this.parse_attr();
        this.skipWhiteSpace();
        char c2 = this.m_filter.charAt(this.m_pos + 1);
        switch (this.m_filter.charAt(this.m_pos)) {
            case '~': {
                if (c2 != '=') break;
                this.m_pos += 2;
                return new StringFilterImpl(topLevel, 2, attr, this.parse_value());
            }
            case '>': {
                if (c2 != '=') break;
                this.m_pos += 2;
                return new StringFilterImpl(topLevel, 3, attr, this.parse_value());
            }
            case '<': {
                if (c2 != '=') break;
                this.m_pos += 2;
                return new StringFilterImpl(topLevel, 4, attr, this.parse_value());
            }
            case '=': {
                if (c2 == '*') {
                    int oldpos = this.m_pos;
                    this.m_pos += 2;
                    this.skipWhiteSpace();
                    if (this.m_filter.charAt(this.m_pos) == ')') {
                        return new PresentFilterImpl(topLevel, attr);
                    }
                    this.m_pos = oldpos;
                }
                ++this.m_pos;
                Object string = this.parse_substring();
                return string instanceof String ? new StringFilterImpl(topLevel, 1, attr, (String)string) : new SubstringFilterImpl(topLevel, attr, (String[])string);
            }
        }
        throw this.syntaxException(Messages.FILTER_INVALID_OPERATOR);
    }

    private FilterImpl parse_not(boolean topLevel) throws InvalidSyntaxException {
        this.skipWhiteSpace();
        if (this.m_filter.charAt(this.m_pos) != '(') {
            throw this.syntaxException(Messages.FILTER_MISSING_LEFTPAREN);
        }
        FilterImpl child = this.parse_filter(false);
        return new NotFilterImpl(topLevel, null, child);
    }

    private FilterImpl parse_or(boolean topLevel) throws InvalidSyntaxException {
        this.skipWhiteSpace();
        char c = this.m_filter.charAt(this.m_pos);
        if (c != '(') {
            throw this.syntaxException(Messages.FILTER_MISSING_LEFTPAREN);
        }
        ArrayList<FilterImpl> operands = new ArrayList<FilterImpl>(10);
        while (c == '(') {
            FilterImpl child = this.parse_filter(false);
            operands.add(child);
            c = this.m_filter.charAt(this.m_pos);
        }
        return new AndOrFilterImpl(topLevel, 8, null, operands.toArray(new FilterImpl[operands.size()]));
    }

    private Object parse_substring() throws InvalidSyntaxException {
        String single;
        ArrayList<String> operands = null;
        this.m_sb.setLength(0);
        block6: while (true) {
            char c = this.m_filter.charAt(this.m_pos);
            switch (c) {
                case ')': {
                    if (this.m_sb.length() <= 0) break block6;
                    String val = this.m_sb.toString();
                    if (operands == null) {
                        return val;
                    }
                    operands.add(val);
                    break block6;
                }
                case '(': {
                    throw this.syntaxException(Messages.FILTER_INVALID_VALUE);
                }
                case '*': {
                    if (operands == null) {
                        operands = new ArrayList<String>();
                    }
                    if (this.m_sb.length() > 0) {
                        operands.add(this.m_sb.toString());
                        this.m_sb.setLength(0);
                    }
                    operands.add(null);
                    ++this.m_pos;
                    continue block6;
                }
                case '\\': {
                    c = this.m_filter.charAt(++this.m_pos);
                }
                default: {
                    this.m_sb.append(c);
                    ++this.m_pos;
                    continue block6;
                }
            }
            break;
        }
        if (operands == null) {
            throw this.syntaxException(Messages.FILTER_MISSING_VALUE);
        }
        int size = operands.size();
        if (size == 1 && (single = (String)operands.get(0)) != null) {
            return single;
        }
        return operands.toArray(new String[size]);
    }

    private String parse_value() throws InvalidSyntaxException {
        this.m_sb.setLength(0);
        block5: while (true) {
            char c = this.m_filter.charAt(this.m_pos);
            switch (c) {
                case ')': {
                    break block5;
                }
                case '(': {
                    throw this.syntaxException(Messages.FILTER_INVALID_VALUE);
                }
                case '\\': {
                    c = this.m_filter.charAt(++this.m_pos);
                }
                default: {
                    this.m_sb.append(c);
                    ++this.m_pos;
                    continue block5;
                }
            }
            break;
        }
        int len = this.m_sb.length();
        while (len > 0 && this.m_sb.charAt(len - 1) <= ' ') {
            --len;
        }
        if (len == 0) {
            throw this.syntaxException(Messages.FILTER_MISSING_VALUE);
        }
        this.m_sb.setLength(len);
        return this.m_sb.toString();
    }

    private void skipWhiteSpace() {
        int top = this.m_filter.length();
        while (this.m_pos < top && Character.isWhitespace(this.m_filter.charAt(this.m_pos))) {
            ++this.m_pos;
        }
    }

    private InvalidSyntaxException syntaxException(String msg) {
        return new InvalidSyntaxException(NLS.bind((String)msg, (Object)this.m_filter, (Object)this.m_pos), this.m_filter);
    }
}

