/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.osgi.filter.impl;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import org.eclipse.buckminster.osgi.filter.impl.FilterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StringFilterImpl
extends FilterImpl {
    private static final Class<?>[] constructorType = new Class[]{String.class};
    private final String m_value;

    StringFilterImpl(boolean topLevel, int operation, String attr, String value) {
        super(topLevel, operation, attr);
        this.m_value = value;
    }

    @Override
    String getValueAsString() {
        return this.m_value;
    }

    @Override
    boolean internalCompare(Object value) {
        if (value instanceof String) {
            return this.compare((String)value);
        }
        Class<?> clazz = value.getClass();
        if (clazz.isArray()) {
            return this.compare(clazz.getComponentType(), value);
        }
        if (value instanceof Integer) {
            return this.compare((Integer)value);
        }
        if (value instanceof Boolean) {
            return this.compare((Boolean)value);
        }
        if (value instanceof Long) {
            return this.compare((Long)value);
        }
        if (value instanceof Byte) {
            return this.compare((Byte)value);
        }
        if (value instanceof Short) {
            return this.compare((Short)value);
        }
        if (value instanceof Character) {
            return this.compare(((Character)value).charValue());
        }
        if (value instanceof Float) {
            return this.compare(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return this.compare((Double)value);
        }
        if (value instanceof Comparable) {
            return this.compareAsComparable((Comparable)value);
        }
        return this.compareUnknown(value);
    }

    @Override
    boolean match0(Map<String, ? extends Object> properties) {
        Object prop = properties == null ? null : properties.get(this.getAttr());
        return this.compare(prop);
    }

    @Override
    void toString(StringBuilder sb) {
        sb.append('(');
        sb.append(this.getAttr());
        switch (this.getOp()) {
            case 1: {
                sb.append('=');
                sb.append(StringFilterImpl.encodeValue(this.m_value));
                break;
            }
            case 3: {
                sb.append(">=");
                sb.append(StringFilterImpl.encodeValue(this.m_value));
                break;
            }
            case 4: {
                sb.append("<=");
                sb.append(StringFilterImpl.encodeValue(this.m_value));
                break;
            }
            case 2: {
                sb.append("~=");
                sb.append(StringFilterImpl.encodeValue(StringFilterImpl.approxString(this.m_value.toString())));
            }
        }
        sb.append(')');
    }

    private boolean compare(boolean boolval) {
        boolean boolval2 = Boolean.parseBoolean(this.m_value.trim());
        switch (this.getOp()) {
            case 1: {
                return boolval == boolval2;
            }
            case 2: {
                return boolval == boolval2;
            }
            case 3: {
                return boolval == boolval2;
            }
        }
        return boolval == boolval2;
    }

    private boolean compare(byte byteval) {
        byte byteval2;
        try {
            byteval2 = Byte.parseByte(this.m_value.trim());
        }
        catch (NumberFormatException e) {
            return false;
        }
        switch (this.getOp()) {
            case 1: {
                return byteval == byteval2;
            }
            case 2: {
                return byteval == byteval2;
            }
            case 3: {
                return byteval >= byteval2;
            }
        }
        return byteval <= byteval2;
    }

    private boolean compare(char charval) {
        int end = this.m_value.length();
        int idx = 0;
        char charval2 = '\u0000';
        while (idx < end) {
            charval2 = this.m_value.charAt(idx);
            if (charval2 > ' ') break;
            ++idx;
        }
        if (idx == end) {
            return false;
        }
        switch (this.getOp()) {
            case 1: {
                return charval == charval2;
            }
            case 2: {
                return charval == charval2 || Character.toUpperCase(charval) == Character.toUpperCase(charval2) || Character.toLowerCase(charval) == Character.toLowerCase(charval2);
            }
            case 3: {
                return charval >= charval2;
            }
        }
        return charval <= charval2;
    }

    private boolean compare(Class<?> type, Object primarray) {
        if (Integer.TYPE.isAssignableFrom(type)) {
            int[] array = (int[])primarray;
            int i = 0;
            int size = array.length;
            while (i < size) {
                if (this.compare(array[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            long[] array = (long[])primarray;
            int i = 0;
            int size = array.length;
            while (i < size) {
                if (this.compare(array[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (Byte.TYPE.isAssignableFrom(type)) {
            byte[] array = (byte[])primarray;
            int i = 0;
            int size = array.length;
            while (i < size) {
                if (this.compare(array[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (Short.TYPE.isAssignableFrom(type)) {
            short[] array = (short[])primarray;
            int i = 0;
            int size = array.length;
            while (i < size) {
                if (this.compare(array[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (Character.TYPE.isAssignableFrom(type)) {
            char[] array = (char[])primarray;
            int i = 0;
            int size = array.length;
            while (i < size) {
                if (this.compare(array[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (Float.TYPE.isAssignableFrom(type)) {
            float[] array = (float[])primarray;
            int i = 0;
            int size = array.length;
            while (i < size) {
                if (this.compare(array[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (Double.TYPE.isAssignableFrom(type)) {
            double[] array = (double[])primarray;
            int i = 0;
            int size = array.length;
            while (i < size) {
                if (this.compare(array[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (Boolean.TYPE.isAssignableFrom(type)) {
            boolean[] array = (boolean[])primarray;
            int i = 0;
            int size = array.length;
            while (i < size) {
                if (this.compare(array[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return false;
    }

    private boolean compare(double doubleval) {
        double doubleval2;
        try {
            doubleval2 = Double.parseDouble(this.m_value.trim());
        }
        catch (NumberFormatException e) {
            return false;
        }
        switch (this.getOp()) {
            case 1: {
                return Double.compare(doubleval, doubleval2) == 0;
            }
            case 2: {
                return Double.compare(doubleval, doubleval2) == 0;
            }
            case 3: {
                return Double.compare(doubleval, doubleval2) >= 0;
            }
        }
        return Double.compare(doubleval, doubleval2) <= 0;
    }

    private boolean compare(float floatval) {
        float floatval2;
        try {
            floatval2 = Float.parseFloat(this.m_value.trim());
        }
        catch (NumberFormatException e) {
            return false;
        }
        switch (this.getOp()) {
            case 1: {
                return Float.compare(floatval, floatval2) == 0;
            }
            case 2: {
                return Float.compare(floatval, floatval2) == 0;
            }
            case 3: {
                return Float.compare(floatval, floatval2) >= 0;
            }
        }
        return Float.compare(floatval, floatval2) <= 0;
    }

    private boolean compare(int intval) {
        int intval2;
        try {
            intval2 = Integer.parseInt(this.m_value.trim());
        }
        catch (NumberFormatException e) {
            return false;
        }
        switch (this.getOp()) {
            case 1: {
                return intval == intval2;
            }
            case 2: {
                return intval == intval2;
            }
            case 3: {
                return intval >= intval2;
            }
        }
        return intval <= intval2;
    }

    private boolean compare(long longval) {
        long longval2;
        try {
            longval2 = Long.parseLong(this.m_value.trim());
        }
        catch (NumberFormatException e) {
            return false;
        }
        switch (this.getOp()) {
            case 1: {
                return longval == longval2;
            }
            case 2: {
                return longval == longval2;
            }
            case 3: {
                return longval >= longval2;
            }
        }
        return longval <= longval2;
    }

    private boolean compare(short shortval) {
        short shortval2;
        try {
            shortval2 = Short.parseShort(this.m_value.trim());
        }
        catch (NumberFormatException e) {
            return false;
        }
        switch (this.getOp()) {
            case 1: {
                return shortval == shortval2;
            }
            case 2: {
                return shortval == shortval2;
            }
            case 3: {
                return shortval >= shortval2;
            }
        }
        return shortval <= shortval2;
    }

    private boolean compare(String string) {
        switch (this.getOp()) {
            case 1: {
                return string.equals(this.m_value);
            }
            case 2: {
                string = StringFilterImpl.approxString(string);
                String string2 = StringFilterImpl.approxString(this.m_value);
                return string.equalsIgnoreCase(string2);
            }
            case 3: {
                return string.compareTo(this.m_value) >= 0;
            }
        }
        return string.compareTo(this.m_value) <= 0;
    }

    private boolean compareAsComparable(Comparable<Object> value1) {
        try {
            Constructor<?> constructor = value1.getClass().getConstructor(constructorType);
            if (!constructor.isAccessible()) {
                AccessController.doPrivileged(new SetAccessibleAction(constructor));
            }
            Object value2 = constructor.newInstance(this.m_value.trim());
            switch (this.getOp()) {
                case 1: 
                case 2: {
                    return value1.compareTo(value2) == 0;
                }
                case 3: {
                    return value1.compareTo(value2) >= 0;
                }
            }
            return value1.compareTo(value2) <= 0;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return false;
    }

    private boolean compareUnknown(Object value1) {
        try {
            Constructor<?> constructor = value1.getClass().getConstructor(constructorType);
            if (!constructor.isAccessible()) {
                AccessController.doPrivileged(new SetAccessibleAction(constructor));
            }
            Object value2 = constructor.newInstance(this.m_value.trim());
            return value1.equals(value2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetAccessibleAction
    implements PrivilegedAction<Object> {
        private final AccessibleObject m_accessible;

        SetAccessibleAction(AccessibleObject accessible) {
            this.m_accessible = accessible;
        }

        @Override
        public Object run() {
            this.m_accessible.setAccessible(true);
            return null;
        }
    }
}

